# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2020 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide2.QtSensors, except for defaults which are replaced by "...".
"""

# Module PySide2.QtSensors
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtCore
import PySide2.QtSensors


class QAccelerometer(PySide2.QtSensors.QSensor):
    Combined                 : QAccelerometer = ... # 0x0
    Gravity                  : QAccelerometer = ... # 0x1
    User                     : QAccelerometer = ... # 0x2

    class AccelerationMode(object):
        Combined                 : QAccelerometer.AccelerationMode = ... # 0x0
        Gravity                  : QAccelerometer.AccelerationMode = ... # 0x1
        User                     : QAccelerometer.AccelerationMode = ... # 0x2

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def accelerationMode(self) -> PySide2.QtSensors.QAccelerometer.AccelerationMode: ...
    def reading(self) -> PySide2.QtSensors.QAccelerometerReading: ...
    def setAccelerationMode(self, accelerationMode:PySide2.QtSensors.QAccelerometer.AccelerationMode) -> None: ...


class QAccelerometerFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QAccelerometerReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QAccelerometerReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def setZ(self, z:float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QAltimeter(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QAltimeterReading: ...


class QAltimeterFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QAltimeterReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QAltimeterReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def altitude(self) -> float: ...
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setAltitude(self, altitude:float) -> None: ...


class QAmbientLightFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QAmbientLightReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QAmbientLightReading(PySide2.QtSensors.QSensorReading):
    Undefined                : QAmbientLightReading = ... # 0x0
    Dark                     : QAmbientLightReading = ... # 0x1
    Twilight                 : QAmbientLightReading = ... # 0x2
    Light                    : QAmbientLightReading = ... # 0x3
    Bright                   : QAmbientLightReading = ... # 0x4
    Sunny                    : QAmbientLightReading = ... # 0x5

    class LightLevel(object):
        Undefined                : QAmbientLightReading.LightLevel = ... # 0x0
        Dark                     : QAmbientLightReading.LightLevel = ... # 0x1
        Twilight                 : QAmbientLightReading.LightLevel = ... # 0x2
        Light                    : QAmbientLightReading.LightLevel = ... # 0x3
        Bright                   : QAmbientLightReading.LightLevel = ... # 0x4
        Sunny                    : QAmbientLightReading.LightLevel = ... # 0x5

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def lightLevel(self) -> PySide2.QtSensors.QAmbientLightReading.LightLevel: ...
    def setLightLevel(self, lightLevel:PySide2.QtSensors.QAmbientLightReading.LightLevel) -> None: ...


class QAmbientLightSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QAmbientLightReading: ...


class QAmbientTemperatureFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QAmbientTemperatureReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QAmbientTemperatureReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setTemperature(self, temperature:float) -> None: ...
    def temperature(self) -> float: ...


class QAmbientTemperatureSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QAmbientTemperatureReading: ...


class QCompass(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QCompassReading: ...


class QCompassFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QCompassReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QCompassReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def azimuth(self) -> float: ...
    def calibrationLevel(self) -> float: ...
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setAzimuth(self, azimuth:float) -> None: ...
    def setCalibrationLevel(self, calibrationLevel:float) -> None: ...


class QDistanceFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QDistanceReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QDistanceReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def distance(self) -> float: ...
    def setDistance(self, distance:float) -> None: ...


class QDistanceSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QDistanceReading: ...


class QGyroscope(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QGyroscopeReading: ...


class QGyroscopeFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QGyroscopeReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QGyroscopeReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def setZ(self, z:float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QHolsterFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QHolsterReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QHolsterReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def holstered(self) -> bool: ...
    def setHolstered(self, holstered:bool) -> None: ...


class QHolsterSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QHolsterReading: ...


class QHumidityFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QHumidityReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QHumidityReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def absoluteHumidity(self) -> float: ...
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def relativeHumidity(self) -> float: ...
    def setAbsoluteHumidity(self, value:float) -> None: ...
    def setRelativeHumidity(self, percent:float) -> None: ...


class QHumiditySensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QHumidityReading: ...


class QIRProximityFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QIRProximityReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QIRProximityReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def reflectance(self) -> float: ...
    def setReflectance(self, reflectance:float) -> None: ...


class QIRProximitySensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QIRProximityReading: ...


class QLidFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QLidReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QLidReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def backLidClosed(self) -> bool: ...
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def frontLidClosed(self) -> bool: ...
    def setBackLidClosed(self, closed:bool) -> None: ...
    def setFrontLidClosed(self, closed:bool) -> None: ...


class QLidSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QLidReading: ...


class QLightFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QLightReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QLightReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def lux(self) -> float: ...
    def setLux(self, lux:float) -> None: ...


class QLightSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def fieldOfView(self) -> float: ...
    def reading(self) -> PySide2.QtSensors.QLightReading: ...
    def setFieldOfView(self, fieldOfView:float) -> None: ...


class QMagnetometer(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QMagnetometerReading: ...
    def returnGeoValues(self) -> bool: ...
    def setReturnGeoValues(self, returnGeoValues:bool) -> None: ...


class QMagnetometerFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QMagnetometerReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QMagnetometerReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def calibrationLevel(self) -> float: ...
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setCalibrationLevel(self, calibrationLevel:float) -> None: ...
    def setX(self, x:float) -> None: ...
    def setY(self, y:float) -> None: ...
    def setZ(self, z:float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QOrientationFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QOrientationReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QOrientationReading(PySide2.QtSensors.QSensorReading):
    Undefined                : QOrientationReading = ... # 0x0
    TopUp                    : QOrientationReading = ... # 0x1
    TopDown                  : QOrientationReading = ... # 0x2
    LeftUp                   : QOrientationReading = ... # 0x3
    RightUp                  : QOrientationReading = ... # 0x4
    FaceUp                   : QOrientationReading = ... # 0x5
    FaceDown                 : QOrientationReading = ... # 0x6

    class Orientation(object):
        Undefined                : QOrientationReading.Orientation = ... # 0x0
        TopUp                    : QOrientationReading.Orientation = ... # 0x1
        TopDown                  : QOrientationReading.Orientation = ... # 0x2
        LeftUp                   : QOrientationReading.Orientation = ... # 0x3
        RightUp                  : QOrientationReading.Orientation = ... # 0x4
        FaceUp                   : QOrientationReading.Orientation = ... # 0x5
        FaceDown                 : QOrientationReading.Orientation = ... # 0x6

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def orientation(self) -> PySide2.QtSensors.QOrientationReading.Orientation: ...
    def setOrientation(self, orientation:PySide2.QtSensors.QOrientationReading.Orientation) -> None: ...


class QOrientationSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QOrientationReading: ...


class QPressureFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QPressureReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QPressureReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def pressure(self) -> float: ...
    def setPressure(self, pressure:float) -> None: ...
    def setTemperature(self, temperature:float) -> None: ...
    def temperature(self) -> float: ...


class QPressureSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QPressureReading: ...


class QProximityFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QProximityReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QProximityReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def close(self) -> bool: ...
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setClose(self, close:bool) -> None: ...


class QProximitySensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QProximityReading: ...


class QRotationFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QRotationReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...


class QRotationReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setFromEuler(self, x:float, y:float, z:float) -> None: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def z(self) -> float: ...


class QRotationSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def hasZ(self) -> bool: ...
    def reading(self) -> PySide2.QtSensors.QRotationReading: ...
    def setHasZ(self, hasZ:bool) -> None: ...


class QSensor(PySide2.QtCore.QObject):
    Buffering                : QSensor = ... # 0x0
    FixedOrientation         : QSensor = ... # 0x0
    AlwaysOn                 : QSensor = ... # 0x1
    AutomaticOrientation     : QSensor = ... # 0x1
    GeoValues                : QSensor = ... # 0x2
    UserOrientation          : QSensor = ... # 0x2
    FieldOfView              : QSensor = ... # 0x3
    AccelerationMode         : QSensor = ... # 0x4
    SkipDuplicates           : QSensor = ... # 0x5
    AxesOrientation          : QSensor = ... # 0x6
    PressureSensorTemperature: QSensor = ... # 0x7
    Reserved                 : QSensor = ... # 0x101

    class AxesOrientationMode(object):
        FixedOrientation         : QSensor.AxesOrientationMode = ... # 0x0
        AutomaticOrientation     : QSensor.AxesOrientationMode = ... # 0x1
        UserOrientation          : QSensor.AxesOrientationMode = ... # 0x2

    class Feature(object):
        Buffering                : QSensor.Feature = ... # 0x0
        AlwaysOn                 : QSensor.Feature = ... # 0x1
        GeoValues                : QSensor.Feature = ... # 0x2
        FieldOfView              : QSensor.Feature = ... # 0x3
        AccelerationMode         : QSensor.Feature = ... # 0x4
        SkipDuplicates           : QSensor.Feature = ... # 0x5
        AxesOrientation          : QSensor.Feature = ... # 0x6
        PressureSensorTemperature: QSensor.Feature = ... # 0x7
        Reserved                 : QSensor.Feature = ... # 0x101

    def __init__(self, type:PySide2.QtCore.QByteArray, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def addFilter(self, filter:PySide2.QtSensors.QSensorFilter) -> None: ...
    def availableDataRates(self) -> typing.List: ...
    def axesOrientationMode(self) -> PySide2.QtSensors.QSensor.AxesOrientationMode: ...
    def backend(self) -> PySide2.QtSensors.QSensorBackend: ...
    def bufferSize(self) -> int: ...
    def connectToBackend(self) -> bool: ...
    def currentOrientation(self) -> int: ...
    def dataRate(self) -> int: ...
    @staticmethod
    def defaultSensorForType(type:PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def description(self) -> str: ...
    def efficientBufferSize(self) -> int: ...
    def error(self) -> int: ...
    def filters(self) -> typing.List: ...
    def identifier(self) -> PySide2.QtCore.QByteArray: ...
    def isActive(self) -> bool: ...
    def isAlwaysOn(self) -> bool: ...
    def isBusy(self) -> bool: ...
    def isConnectedToBackend(self) -> bool: ...
    def isFeatureSupported(self, feature:PySide2.QtSensors.QSensor.Feature) -> bool: ...
    def maxBufferSize(self) -> int: ...
    def outputRange(self) -> int: ...
    def outputRanges(self) -> typing.List: ...
    def reading(self) -> PySide2.QtSensors.QSensorReading: ...
    def removeFilter(self, filter:PySide2.QtSensors.QSensorFilter) -> None: ...
    @staticmethod
    def sensorTypes() -> typing.List: ...
    @staticmethod
    def sensorsForType(type:PySide2.QtCore.QByteArray) -> typing.List: ...
    def setActive(self, active:bool) -> None: ...
    def setAlwaysOn(self, alwaysOn:bool) -> None: ...
    def setAxesOrientationMode(self, axesOrientationMode:PySide2.QtSensors.QSensor.AxesOrientationMode) -> None: ...
    def setBufferSize(self, bufferSize:int) -> None: ...
    def setCurrentOrientation(self, currentOrientation:int) -> None: ...
    def setDataRate(self, rate:int) -> None: ...
    def setEfficientBufferSize(self, efficientBufferSize:int) -> None: ...
    def setIdentifier(self, identifier:PySide2.QtCore.QByteArray) -> None: ...
    def setMaxBufferSize(self, maxBufferSize:int) -> None: ...
    def setOutputRange(self, index:int) -> None: ...
    def setSkipDuplicates(self, skipDuplicates:bool) -> None: ...
    def setUserOrientation(self, userOrientation:int) -> None: ...
    def skipDuplicates(self) -> bool: ...
    def start(self) -> bool: ...
    def stop(self) -> None: ...
    def type(self) -> PySide2.QtCore.QByteArray: ...
    def userOrientation(self) -> int: ...


class QSensorBackend(PySide2.QtCore.QObject):

    def __init__(self, sensor:PySide2.QtSensors.QSensor, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def addDataRate(self, min:float, max:float) -> None: ...
    def addOutputRange(self, min:float, max:float, accuracy:float) -> None: ...
    def isFeatureSupported(self, feature:PySide2.QtSensors.QSensor.Feature) -> bool: ...
    def newReadingAvailable(self) -> None: ...
    def reading(self) -> PySide2.QtSensors.QSensorReading: ...
    def sensor(self) -> PySide2.QtSensors.QSensor: ...
    def sensorBusy(self) -> None: ...
    def sensorError(self, error:int) -> None: ...
    def sensorStopped(self) -> None: ...
    def setDataRates(self, otherSensor:PySide2.QtSensors.QSensor) -> None: ...
    def setDescription(self, description:str) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...


class QSensorBackendFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    def createBackend(self, sensor:PySide2.QtSensors.QSensor) -> PySide2.QtSensors.QSensorBackend: ...


class QSensorChangesInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def sensorsChanged(self) -> None: ...


class QSensorFilter(Shiboken.Object):

    def __init__(self) -> None: ...

    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...
    def setSensor(self, sensor:PySide2.QtSensors.QSensor) -> None: ...


class QSensorGestureManager(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def gestureIds(self) -> typing.List: ...
    def recognizerSignals(self, recognizerId:str) -> typing.List: ...
    def registerSensorGestureRecognizer(self, recognizer:PySide2.QtSensors.QSensorGestureRecognizer) -> bool: ...
    @staticmethod
    def sensorGestureRecognizer(id:str) -> PySide2.QtSensors.QSensorGestureRecognizer: ...


class QSensorGesturePluginInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def createRecognizers(self) -> typing.List: ...
    def name(self) -> str: ...
    def supportedIds(self) -> typing.List: ...


class QSensorGestureRecognizer(PySide2.QtCore.QObject):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def create(self) -> None: ...
    def createBackend(self) -> None: ...
    def gestureSignals(self) -> typing.List: ...
    def id(self) -> str: ...
    def isActive(self) -> bool: ...
    def start(self) -> bool: ...
    def startBackend(self) -> None: ...
    def stop(self) -> bool: ...
    def stopBackend(self) -> None: ...


class QSensorManager(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def createBackend(sensor:PySide2.QtSensors.QSensor) -> PySide2.QtSensors.QSensorBackend: ...
    @staticmethod
    def isBackendRegistered(type:PySide2.QtCore.QByteArray, identifier:PySide2.QtCore.QByteArray) -> bool: ...
    @staticmethod
    def registerBackend(type:PySide2.QtCore.QByteArray, identifier:PySide2.QtCore.QByteArray, factory:PySide2.QtSensors.QSensorBackendFactory) -> None: ...
    @staticmethod
    def setDefaultBackend(type:PySide2.QtCore.QByteArray, identifier:PySide2.QtCore.QByteArray) -> None: ...
    @staticmethod
    def unregisterBackend(type:PySide2.QtCore.QByteArray, identifier:PySide2.QtCore.QByteArray) -> None: ...


class QSensorPluginInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def registerSensors(self) -> None: ...


class QSensorReading(PySide2.QtCore.QObject):
    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setTimestamp(self, timestamp:int) -> None: ...
    def timestamp(self) -> int: ...
    def value(self, index:int) -> typing.Any: ...
    def valueCount(self) -> int: ...


class QTapFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QTapReading) -> bool: ...


class QTapReading(PySide2.QtSensors.QSensorReading):
    Undefined                : QTapReading = ... # 0x0
    X                        : QTapReading = ... # 0x1
    Y                        : QTapReading = ... # 0x2
    Z                        : QTapReading = ... # 0x4
    X_Pos                    : QTapReading = ... # 0x11
    Y_Pos                    : QTapReading = ... # 0x22
    Z_Pos                    : QTapReading = ... # 0x44
    X_Neg                    : QTapReading = ... # 0x101
    X_Both                   : QTapReading = ... # 0x111
    Y_Neg                    : QTapReading = ... # 0x202
    Y_Both                   : QTapReading = ... # 0x222
    Z_Neg                    : QTapReading = ... # 0x404
    Z_Both                   : QTapReading = ... # 0x444

    class TapDirection(object):
        Undefined                : QTapReading.TapDirection = ... # 0x0
        X                        : QTapReading.TapDirection = ... # 0x1
        Y                        : QTapReading.TapDirection = ... # 0x2
        Z                        : QTapReading.TapDirection = ... # 0x4
        X_Pos                    : QTapReading.TapDirection = ... # 0x11
        Y_Pos                    : QTapReading.TapDirection = ... # 0x22
        Z_Pos                    : QTapReading.TapDirection = ... # 0x44
        X_Neg                    : QTapReading.TapDirection = ... # 0x101
        X_Both                   : QTapReading.TapDirection = ... # 0x111
        Y_Neg                    : QTapReading.TapDirection = ... # 0x202
        Y_Both                   : QTapReading.TapDirection = ... # 0x222
        Z_Neg                    : QTapReading.TapDirection = ... # 0x404
        Z_Both                   : QTapReading.TapDirection = ... # 0x444

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def isDoubleTap(self) -> bool: ...
    def setDoubleTap(self, doubleTap:bool) -> None: ...
    def setTapDirection(self, tapDirection:PySide2.QtSensors.QTapReading.TapDirection) -> None: ...
    def tapDirection(self) -> PySide2.QtSensors.QTapReading.TapDirection: ...


class QTapSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def reading(self) -> PySide2.QtSensors.QTapReading: ...
    def returnDoubleTapEvents(self) -> bool: ...
    def setReturnDoubleTapEvents(self, returnDoubleTapEvents:bool) -> None: ...


class QTiltFilter(PySide2.QtSensors.QSensorFilter):

    def __init__(self) -> None: ...

    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QSensorReading) -> bool: ...
    @typing.overload
    def filter(self, reading:PySide2.QtSensors.QTiltReading) -> bool: ...


class QTiltReading(PySide2.QtSensors.QSensorReading):

    def __init__(self, parent:PySide2.QtCore.QObject) -> None: ...

    def copyValuesFrom(self, other:PySide2.QtSensors.QSensorReading) -> None: ...
    def setXRotation(self, x:float) -> None: ...
    def setYRotation(self, y:float) -> None: ...
    def xRotation(self) -> float: ...
    def yRotation(self) -> float: ...


class QTiltSensor(PySide2.QtSensors.QSensor):

    def __init__(self, parent:typing.Optional[PySide2.QtCore.QObject]=...) -> None: ...

    def calibrate(self) -> None: ...
    def reading(self) -> PySide2.QtSensors.QTiltReading: ...


class qoutputrange(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, qoutputrange:PySide2.QtSensors.qoutputrange) -> None: ...

    @staticmethod
    def __copy__() -> None: ...

# eof
