"""Classes to Define the model-view of the main interface."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
from typing import Optional
from uuid import UUID, uuid4

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
# from xms.FhwaVariable.core_data.calculator.tree_data import TreeData
# from xms.FhwaVariable.core_data.calculator.metadata import Metadata
from xms.FhwaVariable.interface_adapters.view_model.window_base import WindowBase


@dataclass
class Application(WindowBase):
    """A class to define the model-view of the main interface."""
    uuid: Optional[UUID] = None

    # options for tool: 'pan', 'zoom', 'rotate', 'select', 'measure'
    gui_tool: str = 'select'

    status_message: str = ''

    # Application data
    menu_bar: dict = field(default_factory=dict)
    tool_bar: dict = field(default_factory=dict)
    center_toolbar_names: list = field(default_factory=list)

    data_tree: list = field(default_factory=list)

    doc_windows: dict = field(default_factory=dict)
    support_windows: list = field(default_factory=list)

    # Document windows layout
    # "tile", "cascade", "minimize all", "maximize all", "restore all"
    doc_windows_layout: str = "maximize all"
    # To add a snap_window_to_edge: [(uuid, edge), ...]
    snap_window_to_edge: Optional[list] = None

    windows: dict = field(default_factory=dict)

    undo_list: list = field(default_factory=list)
    redo_list: list = field(default_factory=list)

    # Application colors
    title_bg_color: tuple = (0, 0, 0)
    title_text_color: tuple = (255, 255, 255)
    bg_color: tuple = (0, 0, 0)
    text_color: tuple = (255, 255, 255)
    selected_bg_color: Optional[tuple] = None
    selected_text_color: Optional[tuple] = None
    hover_bg_color: Optional[tuple] = None
    hover_text_color: Optional[tuple] = None
    item_bg_color: tuple = (0, 0, 0)
    item_text_color: tuple = (255, 255, 255)
    doc_bg_color: tuple = (0, 0, 0)

    # Wiki
    show_wiki: bool = True
    wiki_url: str = ""

    def __post_init__(self):
        """Post-initialization to handle uuid generation."""
        if self.uuid is None:
            self.uuid = uuid4()
