"""Module for the grid_crc function."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['compute_grid_crc']

# 1. Standard Python modules
import binascii

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def compute_grid_crc(path) -> str:
    """
    Compute the CRC of a file.

    Args:
        path: Path to the file.

    Returns:
        The file's CRC.
    """
    with open(path, 'rb') as f:
        crc = hex(binascii.crc32(f.read()) & 0xFFFFFFFF)
    return crc
