"""Entry point to export fort.14 file in parallel with the fort.15."""

# 1. Standard Python modules
import argparse

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 4. Local modules
from xms.adcirc.feedback.xmlog import XmLog
from xms.adcirc.file_io.fort14_writer import export_mapped_bc_data


def main():
    """Entry point wrapper."""
    arguments = argparse.ArgumentParser(description="Entry point to export fort.14 in parallel with fort.15")
    arguments.add_argument(dest='out_file', type=str, help='absolute path to fort.14 file to be exported')
    arguments.add_argument(dest='cogrid_file', type=str, help='absolute path to the domain mesh CoGrid file')
    arguments.add_argument(dest='grid_name', type=str, help='name of the ADCIRC domain mesh')
    arguments.add_argument(
        dest='bc_file', type=str, help='absolute path to the mapped BC component main file', nargs='+'
    )
    parsed_args = arguments.parse_args()
    try:
        XmLog.echo_output = True
        export_mapped_bc_data(
            parsed_args.out_file.strip("'\""), parsed_args.cogrid_file.strip("'\""), parsed_args.grid_name.strip("'\""),
            parsed_args.bc_file
        )
    except Exception as ex:
        msg = 'Error(s) encountered while exporting ADCIRC geometry.'
        XmLog().instance.exception(msg)
        XmEnv.report_error(msg)
        XmEnv.report_error(ex)


if __name__ == '__main__':
    main()
