"""Writes the AdH simulation input files."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query

# 4. Local modules
from xms.adh.components.write_simulation_runner import write_simulation_with_feedback


def main(query: Query) -> bool:
    """Main entry point for simulation export.

    Returns:
        True if successful, False otherwise.
    """
    return write_simulation_with_feedback(query)


if __name__ == '__main__':  # pragma: no cover
    query = Query()
    success = main(query)
    exit(0 if success else 1)
