"""Module for the SimData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['SimData']

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data_bases.sim_base_data import SimBaseData as GmiSimBaseData

# 4. Local modules
from xms.aeolis.data.model import get_model


class SimData(GmiSimBaseData):
    """Data manager for the simulation component."""
    @property
    def process_values(self) -> str:
        """The process dialog values."""
        if 'process_values' in self.info.attrs:
            return self.info.attrs['process_values']
        return get_model().model_parameters.extract_values()

    @process_values.setter
    def process_values(self, value: str):
        """The process dialog values."""
        self.info.attrs['process_values'] = value
