"""StructuresComponent class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'
__all__ = ['StructuresComponent']

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.coverage_component_base import CoverageComponentBase
from xms.gmi.data.generic_model import Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.cmsflow.data.model import get_model


class StructuresComponent(CoverageComponentBase):
    """A Hard bottom component for the CMS-Flow model."""
    def _get_section(self, target: TargetType) -> Section:
        """Get a Section with parameters for a given target."""
        return get_model().section_from_target_type(target)

    @classmethod
    def unique_name(cls) -> str:
        """
        The unique name for this component.

        XMS needs this to be unique for a model. By convention, we just make this equal to the class name.
        """
        return 'Structures'
