"""Module for the `QxIntegerValidator` class."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing import Optional

# 2. Third party modules
from PySide2.QtCore import QObject

# 3. Aquaveo modules

# 4. Local modules
from xms.guipy.validators.qx_double_validator import QxDoubleValidator
from xms.guipy.validators.qx_locale import QxLocale


class QxIntValidator(QxDoubleValidator):
    """A specialization of `QxDoubleValidator` that only takes ints."""
    def __init__(self, bottom: int = -2147483648, top: int = 2147483647, parent: Optional[QObject] = None):
        """
        Initialize the class.

        Args:
            bottom: The minimum value to allow.
            top: The maximum value to allow.
            parent: The parent widget.
        """
        super().__init__(bottom=bottom, top=top, parent=parent, decimals=0, pad=False)

    def fixup(self, value: str) -> str:
        """
        Make a value look nice.

        The parent class already guarantees validity. This just makes it look the way we want.

        Args:
            value: The value to be formatted.

        Returns:
            A formatted version of value.
        """
        reformatted = super().fixup(value)
        integer_part = reformatted.split(QxLocale.decimalPoint())[0]
        return integer_part
