"""Mf6ComponentBase class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.components.bases.component_base import ComponentBase

# 4. Local modules
from xms.mf6.components import dmi_util
from xms.mf6.file_io import io_util


class Mf6ComponentBase(ComponentBase):
    """A Dynamic Model Interface (DMI) component for a GWF (Groundwater Flow) model."""
    def __init__(self, main_file):
        """Initializes the class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)

    def _uuid(self) -> str:
        """Returns the uuid of the component.

        Returns:
            (str): See descriptions.
        """
        if self.main_file:
            return io_util.uuid_from_path(self.main_file)

    def _add_tree_menu_command(self, menu_text, method_name, sim_uuid: str, menu_list, main_file: str = ''):
        """Convenience method for adding a menu command in the project explorer."""
        if not main_file:
            main_file = self.main_file
        dmi_util.add_tree_menu_command(
            menu_text=menu_text,
            method_name=method_name,
            main_file=main_file,
            class_name=self.class_name,
            module_name=self.module_name,
            sim_uuid=sim_uuid,
            menu_list=menu_list
        )
