"""GriddataPackageReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader


class GriddataPackageReader(PackageReader):
    """Reads a package containing only a GRIDDATA block (and optionally an OPTIONS block).

    This applies to: IC, NPF, DSP, IST, MDT, MST.
    """
    def __init__(self, ftype):
        """Initializes the class."""
        super().__init__(ftype=ftype)
        self.ftype = ftype
        self._stop_after_block = 'GRIDDATA'
