"""WriterOptions class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.testing.type_aliases import Pathlike

# 4. Local modules


class WriterOptions:
    """Options for writing a simulation."""

    _dmi_file_list: list[str] = []  # List of component filepaths

    def __init__(
        self,
        mfsim_dir: Pathlike = '',
        use_open_close=True,
        use_input_dir=False,
        use_output_dir=False,
        running_io_tests=False,
        dmi_sim_dir: str = '',
        use_periods_db=False,
        auto_file_naming=False,
        just_name_file=False,
    ):
        """Initializes the class.

        Args:
            mfsim_dir: Path to mfsim.nam directory.
            use_open_close: True to use OPEN/CLOSE for arrays and lists.
            use_input_dir (bool): If True, external files are saved in an "input" subdirectory
            use_output_dir (bool): If True, solution files are saved in an "output" subdirectory
            running_io_tests: True if we're running tests.
            dmi_sim_dir: If not empty, separate directories are created
             for each package in this directory. This is used with XMS DMI. Typically the 'Components' dir.
            use_periods_db (bool): If True, package and period files will be written using the periods.db.
            auto_file_naming (bool): If True, packages under a model use the model filename prefix as their prefix.
            just_name_file: If True, we are writing the model name file, or mfsim.nam file, and won't write children.
        """
        self.mfsim_dir = str(mfsim_dir)  # directory of the mfsim.nam file
        self.use_open_close = use_open_close  # flag to write arrays, lists to external files
        self.use_input_dir = use_input_dir  # flag to write external files to an "input" subdirectory
        self.use_output_dir = use_output_dir  # Flag to write outputs to a directory
        self.running_io_tests = running_io_tests  # debugging flag for when tests are running
        self.dmi_sim_dir = dmi_sim_dir  # Top directory under which package directories are created.
        self.use_periods_db = use_periods_db
        self.auto_file_naming = auto_file_naming  # Filename prefix of model packages are the same as the model
        self.just_name_file = just_name_file

        self.open_close_dir = ''  # directory for external files
        self.output_dir = ''  # directory where outputs will be written
