"""Logging utility functions."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class LogCaptureHandler(logging.Handler):
    """A logging handler that captures log records."""
    def __init__(self, level: int = logging.NOTSET):
        """Initializer."""
        super().__init__(level)
        self.records = []

    def emit(self, record: logging.LogRecord) -> None:
        """Saves the record to the list."""
        self.records.append(record)

    def clear(self) -> None:
        """Clears the list of records."""
        self.records = []
