"""Module for the PtmModelRunTracker."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"
__all__ = ['PtmModelRunTracker']

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.components.dmi.model_run_tracker import ModelRunTracker
from xms.components.dmi.xms_data import XmsData

# 4. Local modules


class PtmModelRunTracker(ModelRunTracker):
    """A progress tracker for PTM."""
    def __init__(self, data: XmsData, args: list[str]):
        """
        Initialize the class.

        Args:
            data: Interprocess communication object.
            args: The tracker's command line arguments.
        """
        super().__init__(data)

        self.in_time_steps = False
        self.num_time_steps = int(args[0])

    def process_line(self, line: str):
        """
        Process a line of stdout from PTM.

        Args:
            line: The line of output to process.
        """
        if line.startswith('Advancing to start time...'):
            self.in_time_steps = True
            return

        if not self.in_time_steps or not line.strip():
            return

        if line.startswith('Run stop'):
            self.current_progress_percent = 1.0
            self.in_time_steps = False
            return

        if line.lstrip().startswith('Trap'):
            return

        current_time_step, _ = line.split(maxsplit=1)
        completed_time_steps = int(current_time_step) - 1
        progress = completed_time_steps / self.num_time_steps
        self.current_progress_percent = progress
