"""CoverageComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.coverage_component_base import CoverageComponentBase
from xms.gmi.data.generic_model import Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.schism.data.model import get_model


class CoverageComponent(CoverageComponentBase):
    """A hidden Dynamic Model Interface (DMI) component for a SCHISM coverage."""
    def __init__(self, main_file):
        """
        Initialize the component class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)
        self._section_dialog_keyword_args['enable_unchecked_groups'] = True
        self._section_dialog_keyword_args['show_groups'] = False

    def _get_section(self, target: TargetType) -> Section:
        """
        Get a section from the coverage's model based on its `TargetType`.

        Args:
            target: `TargetType` for the desired section.

        Returns:
            The section for the feature type.
        """
        section = get_model().section_from_target_type(target)
        if target == TargetType.arc:
            section.group('open').is_active = True
        return section
