"""Module for the `BaseData` class."""

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"

# 1. Standard Python modules
from pathlib import Path
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.component_data import ComponentData

# 4. Local modules
from xms.schism.__version__ import version


class BaseData(ComponentData):
    """Manages data file for a hidden component."""
    def __init__(self, main_file: Optional[str | Path] = None):
        """Initializes the data class.

        Args:
            main_file: Absolute path to the netcdf file associated with this instance data. Usually the owning
                component's main file. If not provided, a default one will be chosen.
        """
        super().__init__(main_file)

        self.info.attrs['SCHISM_FILE_TYPE'] = 'UNKNOWN'
        self.info.attrs['SCHISM_VERSION'] = version

    @property
    def _main_file_name(self) -> str:
        """What to name the component's main file."""
        return 'schism_component.nc'
