"""Module for some CRC hashing functions."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import binascii
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


def compute_crc(file: str | Path) -> str:
    """
    Calculate a file's CRC hash.

    Args:
        file: File to compute the CRC of.

    Returns:
        The file's CRC.
    """
    with open(file, 'rb') as f:
        crc = str(hex(binascii.crc32(f.read())))
        return crc


def compare_crc(file: str | Path, crc: str) -> bool:
    """
    Compare the CRC hash of a file against a given hash.

    Args:
        file: The file to compare.
        crc: The hash to compare against.

    Returns:
        Whether the file matched the hash.
    """
    compare = compute_crc(file)
    return crc == compare
