"""ObstructionParam class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class ObstructionParam(param.Parameterized):
    """Data for obstruction points and arcs."""
    width = param.Number(
        label='Width/diameter',
        default=0.0,
        doc='',
        precedence=1,
    )
    thickness = param.Number(
        label='Thickness (Z-dir)',
        default=0.0,
        doc='',
        precedence=2,
    )
    drag = param.Number(
        label='Drag coefficient (Cd)',
        default=0.0,
        doc='',
        precedence=3,
    )
    units = param.ObjectSelector(
        default='Feet',
        objects=['Feet', 'Meters'],
        doc='',
        precedence=4,
    )
    porosity = param.Number(
        default=0.0,
        doc='',
        precedence=5,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=[],
            depends={},
        )
