"""The SRH-2D project summary report dialog."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import QSize

# 3. Aquaveo modules
from xms.guipy.param.param_dialog_base import ParamDialogBase
from xms.guipy.param.param_layout import ParamLayout

# 4. Local modules


class SummaryReportDialog(ParamDialogBase):
    """A dialog for creating the SRH-2D Project Summary Report."""
    def __init__(self, parent, report_param):  # pragma: no cover
        """Initializes the dialog, sets up the ui.

        Args:
            parent (:obj:`QWidget`): Parent window
            report_param (:obj:`SummaryReport`): Summary report data parameter class
        """
        # TODO: Get the right help URL
        super().__init__(
            parent, report_param, summary_report_layout(), 'SRH-2D Project Summary Report',
            'https://www.xmswiki.com/wiki/SMS', 'xms.srh.gui.summary_report_dialog'
        )
        self.setMinimumSize(QSize(400, 550))


def summary_report_layout():  # pragma: no cover
    """Param layout information for the SummaryReportDialog class."""
    param_layout = dict()
    param_layout['project_purpose'] = ParamLayout(
        multiline_edit=True,
        tab_changes_focus=True,
    )
    param_layout['terrain_source'] = ParamLayout(
        multiline_edit=True,
        tab_changes_focus=True,
    )
    param_layout['bathymetry_source'] = ParamLayout(
        multiline_edit=True,
        tab_changes_focus=True,
    )
    param_layout['additional_survey_source'] = ParamLayout(
        multiline_edit=True,
        tab_changes_focus=True,
    )
    return param_layout
