"""Exports the model files."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os
from pathlib import Path
import typing

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query
from xms.guipy.dialogs.feedback_thread import FeedbackThread

# 4. Local modules
from xms.srh_swmm_coupler.dmi.xms_data import CouplerData
from xms.srh_swmm_coupler.file_io import file_writer


class SimulationExportRunner(FeedbackThread):
    """Exports model files for run."""

    def __init__(self, query: Query, out_dir: typing.Optional[str | Path]):
        """
        Construct the worker.

        Args:
            query (Query): Interprocess communication object.
            out_dir (str): The output directory.
        """
        super().__init__(query, is_export=True, create_query=False)
        self._data = CouplerData(self._query)
        self._out_dir = os.path.normpath(out_dir)

    def _run(self):
        """Run the thread."""
        self._export_input_file()

    def _export_input_file(self):
        """Export the SWMM .inp file."""
        file_writer.write(self._data, self._out_dir)
