"""polygons_from_ugrid_boundary Algorithm."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import logging

# 2. Third party modules

# 3. Aquaveo modules
from xms.constraint import Grid

# 4. Local modules
from xms.tool.algorithms.coverage.grid_cell_to_polygon_coverage_builder import GridCellToPolygonCoverageBuilder


def polygons_from_ugrid_boundary(co_grid: Grid, wkt: str, coverage_name: str, logger: logging.Logger):
    """
    Gets polygons from the given grid's boundary.

    Args:
        co_grid: The Grid to get the polygons from.
        wkt: The wkt of the Grid or None.
        coverage_name: The name of the output coverage.
        logger: Logger for user output.

    Returns:
        (Coverage) Coverage with the resulting data.
    """
    if not co_grid.check_all_cells_2d():
        msg = 'All cells in the grid must be 2D cells.'
        raise ValueError(msg)
    # make sure that only 2d cells exist
    dim_counts = co_grid.ugrid.dimension_counts
    if dim_counts[2] < 1:
        msg = 'The input UGrid must have 2D cells defined.'
        raise ValueError(msg)

    cells = [1] * co_grid.ugrid.cell_count
    b = GridCellToPolygonCoverageBuilder(co_grid=co_grid, dataset_values=cells, wkt=wkt,
                                         coverage_name=coverage_name, logger=logger)
    new_cov = b.create_polygons_and_build_coverage(hash_arcs=False)
    return new_cov
