"""PolygonsFromArcsTool class."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules


# 2. Third party modules


# 3. Aquaveo modules
from xms.tool_core import IoDirection

# 4. Local modules
from xms.tool_xms.coverages.clean_shapes_tool import CleanShapesTool
from xms.tool_xms.gui.merge_polygons_by_distance_dialog import MergePolysByDistanceInvisibleDialog

ARG_INPUT_COVERAGE = 0
ARG_INPUT_TOL = 1
ARG_OUTPUT_COVERAGE = 2


class MergePolysByDistanceTool(CleanShapesTool):
    """Tool to clean geometry."""

    def __init__(self):
        """Initializes the class."""
        super().__init__(name='Merge Polygons by Distance')
        self._mpbd_tolerance = 5.0
        self._use_simplified = False

    def initial_arguments(self):
        """Get initial arguments for tool.

        Must override.

        Returns:
            (list): A list of the initial tool arguments.
        """
        arguments = [
            self.coverage_argument(name='input_coverage', description='Input coverage'),
            self.float_argument(name='merge_tolerance', description='Merge tolerance', value=5.0,
                                min_value=0.0),
            self.coverage_argument(name='output_coverage', description='Output coverage', value='merged',
                                   io_direction=IoDirection.OUTPUT)
        ]
        return arguments

    def enable_arguments(self, arguments):
        """Called to show/hide arguments, change argument values and add new arguments.

        Args:
            arguments(list): The tool arguments.
        """

    def validate_arguments(self, arguments):
        """Called to determine if arguments are valid.

        Args:
            arguments (list): The tool arguments.

        Returns:
            (dict): Dictionary of errors for arguments.
        """
        errors = {}

        return errors

    def run(self, arguments):
        """Override to run the tool.

        Args:
            arguments (list): The tool arguments.
        """
        self._mpbd_tol = float(arguments[ARG_INPUT_TOL].text_value)
        self.process_data(arguments)
        dlg = MergePolysByDistanceInvisibleDialog(None, self)
        if dlg.do_mpbd_tool() is True:
            self.logger.info('Merged successfully.')
        else:
            self.logger.warning('Errors encountered.')
