"""BcComponent class."""

__copyright__ = "(C) Copyright Aquaveo 2021"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.coverage_component_base import CoverageComponentBase as GmiCoverageComponent
from xms.gmi.data.generic_model import Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.wavewatch3.data.model import get_model


class BcComponent(GmiCoverageComponent):
    """A hidden Dynamic Model Interface (DMI) component for the model's simulation."""
    def _get_section(self, target: TargetType) -> Section:
        """Get a Section with parameters for a given target."""
        return get_model().section_from_target_type(target)
