# -*- coding: utf-8 -*-
import param


class MaterialTransportProperties(param.Parameterized):
    refinement_tolerance = param.Number(
        default=1.0,
        bounds=(0, None),
        doc='MP TRT: Transport refinement tolerance (constituent property).',
        precedence=2,
    )
    turbulent_diffusion_rate = param.Number(
        default=0.0,
        bounds=(0, None),
        doc='MP DF: Turbulent diffusion (constituent property).',
        precedence=3,
    )
    use_diffusion_coefficient = param.Boolean(
        default=False,
        doc='Apply turbulent diffusion when exporting.',
        precedence=4,
    )
