# -*- coding: utf-8 -*-
"""
********************************************************************************
* Name:
* Author: Alan Lemon
* Created On: February 15, 2019
* Copyright: (c) Aquaveo 2019
* License: BSD 2-Clause
********************************************************************************
"""

import param


class Mesh(param.Parameterized):
    name = param.String(
        default='',
        doc='Name of the mesh.',
    )
    nodes = param.DataFrame(
        default=None,
        doc='Mesh node locations. Columns ["CARD", "ID", "X", "Y", "Z"]',
    )
    elements = param.DataFrame(
        default=None,
        doc='Mesh elements (triangles) made up of the node ids. '
            'Columns ["CARD", "ID", "NODE_0", "NODE_1", "NODE_2", "MATERIAL_ID"].',
    )
    elements_3d = param.DataFrame(
        default=None,
        doc='Mesh elements made up of the node ids. '
            'Columns ["CARD", "ID", "NODE_0", "NODE_1", "NODE_2", "NODE_3", "MATERIAL_ID", "ELEMENT_2D"].',
    )
