from glob import glob
import logging

log = logging.getLogger('nmutils')


def get_file_list(glob_string: str, file_list: list[str] | None = None) -> list[str]:
    """Merge a glob and an explicit list of files into one list

    Args:
        glob_string(str, optional, default=None):
            string with wild card characters to expand into a list of files with glob
        file_list(list<str>, optional, default=None):
            list of file paths

    Returns:
        merged list of file paths from expanded `glob_string` and `file_list`
    """
    file_list = file_list or list()
    files = glob(glob_string)
    files.extend(file_list)
    if len(files) == 0:
        raise ValueError('No Files were found matching {} or {}.'.format(glob_string, file_list))
    return files
