# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Solver Module

"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _solver
else:
    import _solver

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class NodeStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    avgDepth = property(_solver.NodeStats_avgDepth_get)
    maxDepth = property(_solver.NodeStats_maxDepth_get)
    maxDepthDate = property(_solver.NodeStats_maxDepthDate_get)
    maxRptDepth = property(_solver.NodeStats_maxRptDepth_get)
    volFlooded = property(_solver.NodeStats_volFlooded_get)
    timeFlooded = property(_solver.NodeStats_timeFlooded_get)
    timeSurcharged = property(_solver.NodeStats_timeSurcharged_get)
    timeCourantCritical = property(_solver.NodeStats_timeCourantCritical_get)
    totLatFlow = property(_solver.NodeStats_totLatFlow_get)
    maxLatFlow = property(_solver.NodeStats_maxLatFlow_get)
    maxInflow = property(_solver.NodeStats_maxInflow_get)
    maxOverflow = property(_solver.NodeStats_maxOverflow_get)
    maxPondedVol = property(_solver.NodeStats_maxPondedVol_get)
    nonConvergedCount = property(_solver.NodeStats_nonConvergedCount_get)
    maxInflowDate = property(_solver.NodeStats_maxInflowDate_get)
    maxOverflowDate = property(_solver.NodeStats_maxOverflowDate_get)

    def __init__(self):
        r"""
        Node Statistics

        Attributes
        ----------
        avgDepth: double
            average node depth (level)
        maxDepth: double
            max node depth (level) (from routing step)
        maxDepthDate: DateTime
            date of maximum depth
        maxRptDepth: double
            max node depth (level) (from reporting step)
        volFlooded: double
            total volume flooded (volume)
        timeFlooded: double
            total time flooded
        timeSurcharged: double
            total time surcharged
        timeCourantCritical: double
            total time courant critical
        totLatFlow: double
            total lateral inflow (volume)
        maxLatFlow: double
            maximum lateral inflow (flowrate)
        maxInflow: double
            maximum total inflow (flowrate)
        maxOverflow: double
            maximum flooding (flowrate)
        maxPondedVol: double
            maximum ponded volume (volume)
        maxInflowDate: DateTime
            date of maximum inflow
        maxOverflowDate: DateTime
            date of maximum overflow

        """
        _solver.NodeStats_swiginit(self, _solver.new_NodeStats())
    __swig_destroy__ = _solver.delete_NodeStats

# Register NodeStats in _solver:
_solver.NodeStats_swigregister(NodeStats)
class StorageStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    initVol = property(_solver.StorageStats_initVol_get)
    avgVol = property(_solver.StorageStats_avgVol_get)
    maxVol = property(_solver.StorageStats_maxVol_get)
    maxFlow = property(_solver.StorageStats_maxFlow_get)
    evapLosses = property(_solver.StorageStats_evapLosses_get)
    exfilLosses = property(_solver.StorageStats_exfilLosses_get)
    maxVolDate = property(_solver.StorageStats_maxVolDate_get)

    def __init__(self):
        r"""
        Storage Statistics

        Attributes
        ----------
        initVol: double
            initial volume (volume)
        avgVol: double
            average volume (volume) (from routing step)
        maxVol: double
            maximum volume (volume) (from routing step)
        maxFlow: double
            maximum total inflow (flowrate) (from routing step)
        evapLosses: double
            evaporation losses (volume)
        exfilLosses: double
            exfiltration losses (volume)
        maxVolDate: DateTime
            date of maximum volume

        """
        _solver.StorageStats_swiginit(self, _solver.new_StorageStats())
    __swig_destroy__ = _solver.delete_StorageStats

# Register StorageStats in _solver:
_solver.StorageStats_swigregister(StorageStats)
class OutfallStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, num_pollut):
        r"""
        Outfall Statistics

        Attributes
        ----------
        avgFlow: double
            average flow (flowrate)
        maxFlow: double
            maximum flow (flowrate) (from routing step)
        totalLoad: double *
            total pollutant load (mass)
        totalPeriods: double
            total simulation steps (from routing step)

        """
        _solver.OutfallStats_swiginit(self, _solver.new_OutfallStats(num_pollut))
    __swig_destroy__ = _solver.delete_OutfallStats

    def get_totalLoad(self, index):
        return _solver.OutfallStats_get_totalLoad(self, index)
    avgFlow = property(_solver.OutfallStats_avgFlow_get)
    maxFlow = property(_solver.OutfallStats_maxFlow_get)
    totalLoad = property(_solver.OutfallStats_totalLoad_get)
    totalPeriods = property(_solver.OutfallStats_totalPeriods_get)

# Register OutfallStats in _solver:
_solver.OutfallStats_swigregister(OutfallStats)
class LinkStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    maxFlow = property(_solver.LinkStats_maxFlow_get)
    maxFlowDate = property(_solver.LinkStats_maxFlowDate_get)
    maxVeloc = property(_solver.LinkStats_maxVeloc_get)
    maxDepth = property(_solver.LinkStats_maxDepth_get)
    maxStreetFilled = property(_solver.LinkStats_maxStreetFilled_get)
    timeNormalFlow = property(_solver.LinkStats_timeNormalFlow_get)
    timeInletControl = property(_solver.LinkStats_timeInletControl_get)
    timeSurcharged = property(_solver.LinkStats_timeSurcharged_get)
    timeFullUpstream = property(_solver.LinkStats_timeFullUpstream_get)
    timeFullDnstream = property(_solver.LinkStats_timeFullDnstream_get)
    timeFullFlow = property(_solver.LinkStats_timeFullFlow_get)
    timeCapacityLimited = property(_solver.LinkStats_timeCapacityLimited_get)
    timeInFlowClass = property(_solver.LinkStats_timeInFlowClass_get)
    timeCourantCritical = property(_solver.LinkStats_timeCourantCritical_get)
    flowTurns = property(_solver.LinkStats_flowTurns_get)
    flowTurnSign = property(_solver.LinkStats_flowTurnSign_get)

    def __init__(self):
        r"""
        Link Statistics

        .. rubric:: 'Flow Classes'

        ===========   ===========================
        Flow Class    Description                
        ===========   ===========================
        DRY           dry conduit
        UP_DRY        upstream end is dry
        DN_DRY        downstream end is dry
        SUBCRITICAL   sub-critical flow
        SUPCRITICAL   super-critical flow
        UP_CRITICAL   free-fall at upstream end
        DN_CRITICAL   free-fall at downstream end
        ===========   ===========================

        Attributes
        ----------
        maxFlow: double
            maximum flow (flowrate) (from routing step)
        maxFlowDate: double
            date of maximum flowrate
        maxVeloc: double
            maximum velocity (from routing step)
        maxDepth: double
            maximum depth (level)
        timeNormalFlow: double
            time in normal flow
        timeInletControl: double
            time under inlet control
        timeSurcharged: double
            time surcharged
        timeFullUpstream: double
            time full upstream
        timeFullDnstream: double
            time full downstream
        timeFullFlow: double
            time full flow
        timeCapacityLimited: double
            time capacity limited
        timeInFlowClass: double[7]
            time in flow class (See: 'Flow Classes')
        timeCourantCritical: double
            time courant critical
        flowTurns: double
            number of flow turns
        flowTurnSign: double
            number of flow turns sign

        """
        _solver.LinkStats_swiginit(self, _solver.new_LinkStats())
    __swig_destroy__ = _solver.delete_LinkStats

# Register LinkStats in _solver:
_solver.LinkStats_swigregister(LinkStats)
class PumpStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    utilized = property(_solver.PumpStats_utilized_get)
    minFlow = property(_solver.PumpStats_minFlow_get)
    avgFlow = property(_solver.PumpStats_avgFlow_get)
    maxFlow = property(_solver.PumpStats_maxFlow_get)
    volume = property(_solver.PumpStats_volume_get)
    energy = property(_solver.PumpStats_energy_get)
    offCurveLow = property(_solver.PumpStats_offCurveLow_get)
    offCurveHigh = property(_solver.PumpStats_offCurveHigh_get)
    startUps = property(_solver.PumpStats_startUps_get)
    totalPeriods = property(_solver.PumpStats_totalPeriods_get)

    def __init__(self):
        r"""
        Pump Statistics

        Attributes
        ----------
        utilized: double
            time utilized
        minFlow: double
            minimum flowrate
        avgFlow: double
            average flowrate
        maxFlow: double
            maximum flowrate
        volume: double
            total pumping volume (volume)
        energy: double
            total energy demand
        offCurveLow: double
            hysteresis low (off depth wrt curve)
        offCurveHigh: double
            hysteresis high (on depth wrt curve)
        startUps: int
            number of start ups
        totalPeriods: int
            total simulation steps (from routing step)

        """
        _solver.PumpStats_swiginit(self, _solver.new_PumpStats())
    __swig_destroy__ = _solver.delete_PumpStats

# Register PumpStats in _solver:
_solver.PumpStats_swigregister(PumpStats)
class SubcatchStats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    precip = property(_solver.SubcatchStats_precip_get)
    runon = property(_solver.SubcatchStats_runon_get)
    evap = property(_solver.SubcatchStats_evap_get)
    infil = property(_solver.SubcatchStats_infil_get)
    runoff = property(_solver.SubcatchStats_runoff_get)
    maxFlow = property(_solver.SubcatchStats_maxFlow_get)
    impervRunoff = property(_solver.SubcatchStats_impervRunoff_get)
    pervRunoff = property(_solver.SubcatchStats_pervRunoff_get)

    def __init__(self):
        r"""
        Subcatchment Statistics

        Attributes
        ----------
        precip: double
            total precipication (length)
        runon: double
            total runon (volume)
        evap: double
            total evaporation (volume)
        infil: double
            total infiltration (volume)
        runoff: double
            total runoff (volume)
        maxFlow: double
            maximum runoff rate (flowrate)

        """
        _solver.SubcatchStats_swiginit(self, _solver.new_SubcatchStats())
    __swig_destroy__ = _solver.delete_SubcatchStats

# Register SubcatchStats in _solver:
_solver.SubcatchStats_swigregister(SubcatchStats)
class RoutingTotals(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    dwInflow = property(_solver.RoutingTotals_dwInflow_get)
    wwInflow = property(_solver.RoutingTotals_wwInflow_get)
    gwInflow = property(_solver.RoutingTotals_gwInflow_get)
    iiInflow = property(_solver.RoutingTotals_iiInflow_get)
    exInflow = property(_solver.RoutingTotals_exInflow_get)
    flooding = property(_solver.RoutingTotals_flooding_get)
    outflow = property(_solver.RoutingTotals_outflow_get)
    evapLoss = property(_solver.RoutingTotals_evapLoss_get)
    seepLoss = property(_solver.RoutingTotals_seepLoss_get)
    reacted = property(_solver.RoutingTotals_reacted_get)
    initStorage = property(_solver.RoutingTotals_initStorage_get)
    finalStorage = property(_solver.RoutingTotals_finalStorage_get)
    pctError = property(_solver.RoutingTotals_pctError_get)

    def __init__(self):
        r"""
        System Flow Routing Totals

        Attributes
        ----------
        dwInflow: double
            dry weather inflow
        wwInflow: double
            wet weather inflow
        gwInflow: double
            groundwater inflow
        iiInflow: double
            RDII inflow
        exInflow: double
            direct inflow
        flooding: double
            internal flooding
        outflow: double
            external outflow
        evapLoss: double
            evaporation loss
        seepLoss: double
            seepage loss
        reacted: double
            reaction losses
        initStorage: double
            initial storage volume
        finalStorage: double
            final storage volume
        pctError: double
            continuity error

        """
        _solver.RoutingTotals_swiginit(self, _solver.new_RoutingTotals())
    __swig_destroy__ = _solver.delete_RoutingTotals

# Register RoutingTotals in _solver:
_solver.RoutingTotals_swigregister(RoutingTotals)
class RunoffTotals(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    rainfall = property(_solver.RunoffTotals_rainfall_get)
    evap = property(_solver.RunoffTotals_evap_get)
    infil = property(_solver.RunoffTotals_infil_get)
    runoff = property(_solver.RunoffTotals_runoff_get)
    drains = property(_solver.RunoffTotals_drains_get)
    runon = property(_solver.RunoffTotals_runon_get)
    initStorage = property(_solver.RunoffTotals_initStorage_get)
    finalStorage = property(_solver.RunoffTotals_finalStorage_get)
    initSnowCover = property(_solver.RunoffTotals_initSnowCover_get)
    finalSnowCover = property(_solver.RunoffTotals_finalSnowCover_get)
    snowRemoved = property(_solver.RunoffTotals_snowRemoved_get)
    pctError = property(_solver.RunoffTotals_pctError_get)

    def __init__(self):
        r"""
        System Runoff Totals

        Attributes
        ----------
        rainfall: double
            rainfall total (depth)
        evap: double
            evaporation loss (volume)
        infil: double
            infiltration loss (volume)
        runoff: double
            runoff volume (volume)
        drains: double
            LID drains (volume)
        runon: double
            runon from outfalls (volume)
        initStorage: double
            inital surface storage (depth)
        finalStorage: double
            final surface storage (depth)
        initSnowCover: double
            initial snow cover (depth)
        finalSnowCover: double
            final snow cover (depth)
        snowRemoved: double
            snow removal (depth)
        pctError: double
            continuity error (%)

        """
        _solver.RunoffTotals_swiginit(self, _solver.new_RunoffTotals())
    __swig_destroy__ = _solver.delete_RunoffTotals

# Register RunoffTotals in _solver:
_solver.RunoffTotals_swigregister(RunoffTotals)
swmm_GAGE = _solver.swmm_GAGE
swmm_SUBCATCH = _solver.swmm_SUBCATCH
swmm_NODE = _solver.swmm_NODE
swmm_LINK = _solver.swmm_LINK
swmm_SYSTEM = _solver.swmm_SYSTEM
swmm_JUNCTION = _solver.swmm_JUNCTION
swmm_OUTFALL = _solver.swmm_OUTFALL
swmm_STORAGE = _solver.swmm_STORAGE
swmm_DIVIDER = _solver.swmm_DIVIDER
swmm_CONDUIT = _solver.swmm_CONDUIT
swmm_PUMP = _solver.swmm_PUMP
swmm_ORIFICE = _solver.swmm_ORIFICE
swmm_WEIR = _solver.swmm_WEIR
swmm_OUTLET = _solver.swmm_OUTLET
swmm_GAGE_RAINFALL = _solver.swmm_GAGE_RAINFALL
swmm_SUBCATCH_AREA = _solver.swmm_SUBCATCH_AREA
swmm_SUBCATCH_RAINGAGE = _solver.swmm_SUBCATCH_RAINGAGE
swmm_SUBCATCH_RAINFALL = _solver.swmm_SUBCATCH_RAINFALL
swmm_SUBCATCH_EVAP = _solver.swmm_SUBCATCH_EVAP
swmm_SUBCATCH_INFIL = _solver.swmm_SUBCATCH_INFIL
swmm_SUBCATCH_RUNOFF = _solver.swmm_SUBCATCH_RUNOFF
swmm_SUBCATCH_RPTFLAG = _solver.swmm_SUBCATCH_RPTFLAG
swmm_NODE_TYPE = _solver.swmm_NODE_TYPE
swmm_NODE_ELEV = _solver.swmm_NODE_ELEV
swmm_NODE_MAXDEPTH = _solver.swmm_NODE_MAXDEPTH
swmm_NODE_DEPTH = _solver.swmm_NODE_DEPTH
swmm_NODE_HEAD = _solver.swmm_NODE_HEAD
swmm_NODE_VOLUME = _solver.swmm_NODE_VOLUME
swmm_NODE_LATFLOW = _solver.swmm_NODE_LATFLOW
swmm_NODE_INFLOW = _solver.swmm_NODE_INFLOW
swmm_NODE_OVERFLOW = _solver.swmm_NODE_OVERFLOW
swmm_NODE_RPTFLAG = _solver.swmm_NODE_RPTFLAG
swmm_LINK_TYPE = _solver.swmm_LINK_TYPE
swmm_LINK_NODE1 = _solver.swmm_LINK_NODE1
swmm_LINK_NODE2 = _solver.swmm_LINK_NODE2
swmm_LINK_LENGTH = _solver.swmm_LINK_LENGTH
swmm_LINK_SLOPE = _solver.swmm_LINK_SLOPE
swmm_LINK_FULLDEPTH = _solver.swmm_LINK_FULLDEPTH
swmm_LINK_FULLFLOW = _solver.swmm_LINK_FULLFLOW
swmm_LINK_SETTING = _solver.swmm_LINK_SETTING
swmm_LINK_TIMEOPEN = _solver.swmm_LINK_TIMEOPEN
swmm_LINK_TIMECLOSED = _solver.swmm_LINK_TIMECLOSED
swmm_LINK_FLOW = _solver.swmm_LINK_FLOW
swmm_LINK_DEPTH = _solver.swmm_LINK_DEPTH
swmm_LINK_VELOCITY = _solver.swmm_LINK_VELOCITY
swmm_LINK_TOPWIDTH = _solver.swmm_LINK_TOPWIDTH
swmm_LINK_RPTFLAG = _solver.swmm_LINK_RPTFLAG
swmm_STARTDATE = _solver.swmm_STARTDATE
swmm_CURRENTDATE = _solver.swmm_CURRENTDATE
swmm_ELAPSEDTIME = _solver.swmm_ELAPSEDTIME
swmm_ROUTESTEP = _solver.swmm_ROUTESTEP
swmm_MAXROUTESTEP = _solver.swmm_MAXROUTESTEP
swmm_REPORTSTEP = _solver.swmm_REPORTSTEP
swmm_TOTALSTEPS = _solver.swmm_TOTALSTEPS
swmm_NOREPORT = _solver.swmm_NOREPORT
swmm_FLOWUNITS = _solver.swmm_FLOWUNITS
swmm_CFS = _solver.swmm_CFS
swmm_GPM = _solver.swmm_GPM
swmm_MGD = _solver.swmm_MGD
swmm_CMS = _solver.swmm_CMS
swmm_LPS = _solver.swmm_LPS
swmm_MLD = _solver.swmm_MLD

def swmm_run(f1, f2, f3):
    r"""
    Opens SWMM input file, reads in network data, runs, and closes

    Parameters
    ----------
    f1: char const *
        pointer to name of input file (must exist)
    f2: char const *
        pointer to name of report file (to be created)
    f3: char const *
        pointer to name of binary output file (to be created)

    """
    return _solver.swmm_run(f1, f2, f3)

def swmm_open(f1, f2, f3):
    r"""
    Opens SWMM input file & reads in network data

    Parameters
    ----------
    f1: char const *
        pointer to name of input file (must exist)
    f2: char const *
        pointer to name of report file (to be created)
    f3: char const *
        pointer to name of binary output file (to be created)

    """
    return _solver.swmm_open(f1, f2, f3)

def swmm_start(saveFlag):
    r"""
    Start SWMM simulation

    Parameters
    ----------
    saveFlag: int
        TRUE or FALSE to save timeseries to report file

    """
    return _solver.swmm_start(saveFlag)

def swmm_step():
    r"""
    Step SWMM simulation forward

    Returns
    -------
    elapsedTime: double
        elapsed simulation time [milliseconds]

    """
    return _solver.swmm_step()

def swmm_stride(strideStep):
    return _solver.swmm_stride(strideStep)

def swmm_end():
    r"""
    End SWMM simulation   

    """
    return _solver.swmm_end()

def swmm_report():
    r"""
    Write text report file

    """
    return _solver.swmm_report()

def swmm_close():
    r"""
    Frees all memory and files used by SWMM

    """
    return _solver.swmm_close()

def swmm_get_mass_balance():
    r"""
    Get routing errors

    Returns
    -------
    runoffErr: float *
        Runoff routing error
    flowErr: float * 
        Flow routing error
    qualErr: float * 
        Quality routing error

    """
    return _solver.swmm_get_mass_balance()

def swmm_get_version():
    r"""
    Get Legacy SWMM version number

    Returns
    -------
    version: int
        Version number

    """
    return _solver.swmm_get_version()

def swmm_version_info():
    return _solver.swmm_version_info()

def swmm_build_id():
    return _solver.swmm_build_id()

def project_get_index(type, id):
    r"""
    Finds the index of an object given its ID.

    Parameters
    ----------
    type: SM_ObjectType
        type An object type (see :ref: SM_ObjectType)
    id: char *
        id The object ID

    Returns
    -------    
    index: int *
        The objects index

    """
    return _solver.project_get_index(type, id)

def simulation_get_unit(type):
    r"""
    Gets Simulation Unit

    Parameters
    ----------
    type: SM_Units
        Option code (see :ref: SM_Units)

    Returns
    -------
    value: int *
        Option value

    """
    return _solver.simulation_get_unit(type)

def simulation_get_setting(type):
    r"""
    Gets Simulation Analysis Setting

    Parameters
    ----------
    type: SM_SimOption
        Option code (see :ref: SM_SimOption)

    Returns
    -------
    value: int *
        Option value

    """
    return _solver.simulation_get_setting(type)

def simulation_get_parameter(type):
    r"""
    Gets Simulation Analysis Setting

    Parameters
    ----------
    type: SM_SimSetting
        Option code (see :ref: SM_SimSetting)

    Returns
    -------
    value: double *
        Option value

    """
    return _solver.simulation_get_parameter(type)

def swmm_setSimulationParam(type, value):
    return _solver.swmm_setSimulationParam(type, value)

def swmm_hotstart(type, hsfile):
    r"""
    Load or save a hotstart file into or out of a running simulation.

    Parameters
    ----------
    operation: SM_HotStart
        The hotstart operation to use (i.e. save or load)
    hsfile: str
        The path to the hotstart file to either save or load

    """
    return _solver.swmm_hotstart(type, hsfile)

def project_get_count(type):
    r"""
    Gets Object Count

    Parameters
    ----------
    type: SM_ObjectType
        Option code (see :ref: SM_ObjectType)

    Returns
    -------
    count: int *
        Option value

    """
    return _solver.project_get_count(type)

def project_get_id(type, index):
    r"""
    Gets Object ID

    Parameters
    ----------
    type: SM_ObjectType
        type Option code (see :ref: SM_ObjectType)
    index: int
        index of the Object

    Returns
    -------
    id: char **
        The string ID of object.

    """
    return _solver.project_get_id(type, index)

def node_get_type(index):
    r"""
    Get the type of node with specified index.

    Parameters
    ----------
    index: int
        The index of a node

    Returns
    -------
    Ntype: SM_NodeType *
        The type code for the node (:ref: SM_NodeType). 
        id must be pre-allocated by the caller.

    """
    return _solver.node_get_type(index)

def link_get_type(index):
    r"""
    Get the type of link with specified index.

    Parameters
    ----------
    index: int
        The index of a link

    Returns
    -------
    Ltype: SM_LinkType *
        The type code for the link (:ref: SM_LinkType).

    """
    return _solver.link_get_type(index)

def link_get_connections(index):
    r"""
    Get the link Connection Node Indeces. If the conduit has a negative slope, 
    the dynamic wave solver will automatically reverse the nodes. 

    Parameters
    ----------
    index: int
        The index of a link

    Returns
    -------
    Node1: int *
        The upstream node index.
    Node2: int *
        The downstream node index.

    """
    return _solver.link_get_connections(index)

def link_get_direction(index):
    r"""
    Get the link flow direction

    Parameters
    ----------
    index: int
        The index of a link

    Returns
    -------
    value: char *
        The link flow direction.

    """
    return _solver.link_get_direction(index)

def subcatch_get_connection(index):
    r"""
    Get the Subcatchment connection. Subcatchments can load to a node, another 
    subcatchment, or itself.

    Parameters
    ----------
    index: int
        The index of a Subcatchment

    Returns
    -------
    type: SM_ObjectType
        The type of object loading (See :ref: SM_ObjectType)
    out_index: int *
        The object index

    """
    return _solver.subcatch_get_connection(index)

def lid_usage_get_count(index):
    r"""
    Get the number of lid units on a subcatchment.

    Parameters
    ----------
    index: int
        The index of a subcatchment

    Returns
    -------
    value: int *
        The number of lid units on a subcatchment

    """
    return _solver.lid_usage_get_count(index)

def lid_usage_get_parameter(index, lidIndex, param):
    r"""
    Get a property value for a specified lid unit on a specified subcatchment

    Parameters
    ----------
    index: int
        The index of a subcatchment
    lidIndex: int
        The index of specified lid unit
    param: SM_LidUProperty
        The property type code (See :ref: SM_LidUProperty)

    Returns
    -------
    value: double
        The value of the lid unit's property

    """
    return _solver.lid_usage_get_parameter(index, lidIndex, param)

def lid_usage_set_parameter(index, lidIndex, param, value):
    r"""
    Set a property value for a specified lid unit on a specified subcatchment

    Parameters
    ----------
    index: int
        The index of a subcatchment
    lidIndex: int
        The index of specified lid unit
    param: SM_LidUProperty
        The property type code (See :ref: SM_LidUProperty)
    value: double
        The new value of the lid unit's property

    """
    return _solver.lid_usage_set_parameter(index, lidIndex, param, value)

def lid_usage_get_option(index, lidIndex, param):
    r"""
    Get the lid option for a specified lid unit on a specified subcatchment

    Parameters
    ----------
    index: int
        The index of a subcatchment
    lidIndex: int
        The index of specified lid unit
    param: SM_LidUOptions
        The lid option type code (See :ref: SM_LidUOptions)

    Returns
    -------
    value: int *
        The value of the option for the lid unit

    """
    return _solver.lid_usage_get_option(index, lidIndex, param)

def lid_usage_set_option(index, lidIndex, param, value):
    r"""
    Set the lid option for a specified lid unit on a specified subcatchment

    Parameters
    ----------
    index: int
        The index of a subcatchment
    lidIndex: int
        The index of specified lid unit
    param: SM_LidUOptions
        The lid option type code (See :ref: SM_LidUOptions)
    value: int
        The new value of the option for the lid unit

    """
    return _solver.lid_usage_set_option(index, lidIndex, param, value)

def lid_control_get_overflow(lidControlIndex):
    r"""
    Get the lid control surface immediate overflow condition

    Parameters
    ----------
    lidControlIndex: int
        The index of specified lid control

    Returns
    -------
    condition: int *
        The value of surface immediate overflow condition

    """
    return _solver.lid_control_get_overflow(lidControlIndex)

def lid_control_get_parameter(lidControlIndex, layerIndex, param):
    r"""
    Get a property value for specified lid control

    Parameters
    ----------
    lidControlIndex: int
        The index of specified lid control
    layerIndex: SM_LidLayer
        The index of specified lid layer (See :ref: SM_LidLayer)
    param: SM_LidLayerProperty
        The property type code (See :ref: SM_LidLayerProperty)

    Returns
    -------
    value: double 
        The value of lid control's property

    """
    return _solver.lid_control_get_parameter(lidControlIndex, layerIndex, param)

def lid_control_set_parameter(lidControlIndex, layerIndex, param, value):
    r"""
    Set a property value for specified lid control

    Parameters
    ----------
    lidControlIndex: int
        The index of specified lid control
    layerIndex: SM_LidLayer
        The index of specified lid layer (See :ref: SM_LidLayer)
    param: SM_LidLayerProperty
        The property type code (See :ref: SM_LidLayerProperty)
    value: double
        The new value for the lid control's property

    """
    return _solver.lid_control_set_parameter(lidControlIndex, layerIndex, param, value)

def lid_usage_get_flux_rate(index, lidIndex, layerIndex):
    r"""
    Get the lid unit water balance simulated value at current time

    Parameters
    ----------
    index: int
        The index of a subcatchment
    lidIndex: int
        The index of specified lid unit
    layerIndex: SM_LidLayer
        The index of specified lid layer (See :ref: SM_LidLayer)

    Returns
    -------
    result: double * 
        The result for the specified lid unit

    """
    return _solver.lid_usage_get_flux_rate(index, lidIndex, layerIndex)

def lid_group_get_result(index, type):
    r"""
    Get the lid group of a specified subcatchment result at current time

    Parameters
    ----------
    index: int
        The index of a subcatchment
    type: SM_LidResult
        The result type code (See :ref: SM_LidResult)

    Returns
    -------
    result: double *
        The result for the specified lid group

    """
    return _solver.lid_group_get_result(index, type)

def lid_usage_get_result(index, lidIndex, type):
    r"""
    Get the lid unit of a specified subcatchment result at current time

    Parameters
    ----------
    index: int
        The index of a subcatchment
    lidIndex: int
        The index of specified lid unit
    type: SM_LidResult
        The result type code (See :ref: SM_LidResult)

    Returns
    -------
    result: double *
        The result for the specified lid unit

    """
    return _solver.lid_usage_get_result(index, lidIndex, type)

def node_get_parameter(index, param):
    r"""
    Get a property value for specified node.

    Parameters
    ----------
    index: int
        The index of a node
    param: SM_NodeProperty
        The property type code (See :ref: SM_NodeProperty)

    Returns
    -------
    value: double *
        The value of the node's property

    """
    return _solver.node_get_parameter(index, param)

def node_set_parameter(index, param, value):
    r"""
    Set a property value for specified node.

    Parameters
    ----------
    index: int
        The index of a node
    param: SM_NodeProperty
        The property type code (See :ref: SM_NodeProperty)
    value: double
        The new value of the node's property

    """
    return _solver.node_set_parameter(index, param, value)

def link_get_parameter(index, param):
    r"""
    Get a property value for specified link.

    Parameters
    ----------
    index: int
        The index of a link
    param: SM_LinkProperty
        The property type code (See :ref: SM_LinkProperty)

    Returns
    -------
    value: double *
        The value of the link's property

    """
    return _solver.link_get_parameter(index, param)

def link_set_parameter(index, param, value):
    r"""
    Set a property value for specified link.

    Parameters
    ----------
    index: int
        The index of a link
    param: SM_LinkProperty
        The property type code (See :ref: SM_LinkProperty)
    value: double
        The new value of the link's property

    """
    return _solver.link_set_parameter(index, param, value)

def inlet_get_parameter(index, param):
    r"""
    Get a property value for the inlet of a specified link.

    Parameters
    ----------
    index: int
        The index of a link with desired inlets
    param: SM_InletProperty
        The property type code (See :ref: SM_InletProperty)

    Returns
    -------
    value: double *
        The value of the inlet's property

    """
    return _solver.inlet_get_parameter(index, param)

def inlet_set_parameter(index, param, value):
    r"""
    Get a property value for the inlet of a specified link.

    Parameters
    ----------
    index: int
        The index of a link with desired inlets
    param: SM_InletProperty
        The property type code (See :ref: SM_InletProperty)

    Returns
    -------
    value: double *
        The new value of the inlet's property

    """
    return _solver.inlet_set_parameter(index, param, value)

def subcatch_get_parameter(index, param):
    r"""
    Get a property value for specified subcatchment.

    Parameters
    ----------
    index: int
        The index of a subcatchment
    param: SM_SubcProperty
        The property type code (See :ref: SM_SubcProperty)

    Returns
    -------
    value: double *
        The value of the subcatchment's property

    """
    return _solver.subcatch_get_parameter(index, param)

def subcatch_set_parameter(index, param, value):
    r"""
    Set a property value for specified subcatchment.

    Parameters
    ----------
    index: int
        The index of a subcatchment
    param: SM_SubcProperty
        The property type code (See :ref: SM_SubcProperty)
    value: double
        The new value of the subcatchment's property

    """
    return _solver.subcatch_set_parameter(index, param, value)

def simulation_get_datetime(type):
    r"""
    Get the simulation datetime information

    Parameters
    ----------
    type: SM_TimePropety
        The property type code (See :ref: SM_TimePropety)

    Returns
    -------
    year: int *
        The year
    month: int *
        The month
    day: int *
        The day
    hour: int *
        The hour
    minute: int *
        The minute
    second: int *
        The seconds

    """
    return _solver.simulation_get_datetime(type)

def simulation_set_datetime(type, year, month, day, hour, minute, second):
    r"""
    Set simulation datetime information.

    Parameters
    ----------
    type: SM_TimePropety 
        type The property type code (See :ref: SM_TimePropety)
    year: int
        The year
    month: int
        The month
    day: int
        The day
    hour: int
        The hour
    minute: int
        The minute
    second: int
        The seconds

    """
    return _solver.simulation_set_datetime(type, year, month, day, hour, minute, second)

def simulation_get_current_datetime():
    r"""
    Get the current simulation datetime information.

    Returns
    -------
    year: int *
        The year
    month: int *
        The month
    day: int *
        The day
    hour: int *
        The hour
    minute: int *
        The minute
    second: int *
        The seconds

    """
    return _solver.simulation_get_current_datetime()

def node_get_result(index, type):
    r"""
    Get a result value for specified node.

    Parameters
    ----------
    index: int
        The index of a node
    type: SM_NodeResult
        The property type code (See :ref: SM_NodeResult)

    Returns
    -------
    result: double *
        The result of the node's property

    """
    return _solver.node_get_result(index, type)

def node_get_pollutant(index, type):
    r"""
    Gets pollutant values for a specified node.

    Parameters
    ----------
    index: int
        The index of a node
    type: SM_NodePollut
        The property type code (see :ref: SM_NodePollut)

    Returns
    -------
    PollutArray: double *
        result array

    """
    return _solver.node_get_pollutant(index, type)

def node_set_pollutant(index, type, pollutant_index, pollutant_value):
    r"""
    Set node pollutant concentration

    Parameters
    ----------
    index: int
        The node index.
    type: SM_NodePollut
        The property type code (see :ref: SM_NodePollut). Currently Only QUALITY (0) is supported.
    pollutant_index: int
        The index of the pollutant to set.
    pollutant_value:
        The new pollutant concentration to set.


    """
    return _solver.node_set_pollutant(index, type, pollutant_index, pollutant_value)

def link_set_pollutant(index, type, pollutant_index, pollutant_value):
    r"""
    Set link pollutant concentration

    Parameters
    ----------
    index: int
        The link index.
    type: SM_LinkPollut
        The property type code (see :ref: SM_LinkPollut). Currently Only QUALITY (0) is supported.
    pollutant_index: int
        The index of the pollutant to set.
    pollutant_value:
        The new pollutant concentration to set.


    """
    return _solver.link_set_pollutant(index, type, pollutant_index, pollutant_value)

def link_get_result(index, type):
    r"""
    Get a result value for specified link.

    Parameters
    ----------
    index: int
        The index of a link
    type: SM_LinkResult
        The property type code (See :ref: SM_LinkResult)

    Returns
    -------
    result: double *
        The result of the link's property

    """
    return _solver.link_get_result(index, type)

def inlet_get_result(index, type):
    r"""
    Get a result value for specified link.

    Parameters
    ----------
    index: int
        The index of a link with desired inlets
    type: SM_InletResult
        The result type code (See :ref: SM_InletResult)

    Returns
    -------
    result: double *
        The value of the inlet's result at the current simulation timestep

    """
    return _solver.inlet_get_result(index, type)

def link_get_pollutant(index, type):
    r"""
    Gets pollutant values for a specified link.

    Parameters
    ----------
    index: int
        The index of a link
    type: SM_LinkPollut
        The property type code (see :ref: SM_LinkPollut)

    Returns
    -------
    PollutArray: double *
        result array

    """
    return _solver.link_get_pollutant(index, type)

def subcatch_get_result(index, type):
    r"""
    Get a result value for specified subcatchment.

    Parameters
    ----------
    index: int
        The index of a subcatchment
    type: SM_SubcResult
        The property type code (See :ref: SM_SubcResult)

    Returns
    -------
    result: double *
        The result of the subcatchment's property

    """
    return _solver.subcatch_get_result(index, type)

def subcatch_get_pollutant(index, type):
    r"""
    Gets pollutant values for a specified subcatchment.

    Parameters
    ----------
    index: int
        The index of a subcatchment
    type: SM_SubcPollut
        The property type code (see :ref: SM_SubcPollut)

    Returns
    -------
    PollutArray: double **
        result array

    """
    return _solver.subcatch_get_pollutant(index, type)

def raingage_get_precipitation(index, type):
    r"""
    Get precipitation rates for a gage.

    Parameters
    ----------
    index: int
        The index of gage
    type: SM_GagePrecip
        The property type code (see :ref: SM_GagePrecip)

    Returns
    -------
    GageArray: double *
        precipitation rate

    """
    return _solver.raingage_get_precipitation(index, type)

def node_get_stats(index):
    r"""
    Get a node statistics.

    Parameters
    ----------
    index: int
        The index of a node

    Returns
    -------
    nodeStats: SM_NodeStats * 
        The Node Stats struct (see :ref: SM_NodeStats) pre-allocated by the caller.

    """
    return _solver.node_get_stats(index)

def node_get_total_inflow(index):
    r"""
    Get the cumulative inflow for a node.

    Parameters
    ----------
    index: int
        The index of a node

    Returns
    -------
    value: double *
        The total inflow.

    """
    return _solver.node_get_total_inflow(index)

def storage_get_stats(index):
    r"""
    Get a storage statistics.

    Parameters
    ----------
    index: int
        The index of a storage node

    Returns
    -------
    storageStats: SM_StorageStats * 
        The storage Stats struct (see :ref: SM_StorageStats) pre-allocated by the caller.

    """
    return _solver.storage_get_stats(index)

def outfall_get_stats(index):
    r"""
    Get outfall statistics.

    Parameters
    ----------
    index: int
        The index of a outfall node

    Returns
    -------
    outfallStats: SM_OutfallStats * 
        The outfall Stats struct (see :ref: SM_OutfallStats).
        pre-allocated by the caller. Caller is also responsible for freeing the
        SM_OutfallStats structure using swmm_freeOutfallStats(). This frees any
        pollutants array.

    """
    return _solver.outfall_get_stats(index)

def link_get_stats(index):
    r"""
    Get link statistics.

    Parameters
    ----------
    index: int
        The link index.

    Returns
    -------
    linkStats: SM_LinkStats *
        The link Stats struct (see :ref: SM_LinkStats). pre-allocated by the caller.

    """
    return _solver.link_get_stats(index)

def pump_get_stats(index):
    r"""
    Get pump statistics.

    Parameters
    ----------
    index: int
        The index of a pump

    Returns
    -------
    pumpStats: SM_PumpStats *
        The link Stats struct (see :ref: SM_PumpStats). pre-allocated by the caller.

    """
    return _solver.pump_get_stats(index)

def subcatch_get_stats(index):
    r"""
    Get subcatchment statistics.

    Parameters
    ----------
    index: int
        The index of a subcatchment

    Returns
    -------
    subcatchStats: SM_SubcatchStats *
        The link Stats struct (see :ref: SM_SubcatchStats).
        pre-allocated by the caller. Caller is also responsible for freeing the
        SM_SubcatchStats structure using swmm_freeSubcatchStats(). This frees any
        pollutants array.

    """
    return _solver.subcatch_get_stats(index)

def system_get_routing_totals():
    r"""
    Get system routing totals.

    Returns
    -------
    routingTot: SM_RoutingTotals *
        The system Routing Stats struct (see :ref: SM_RoutingTotals).
        pre-allocated by the caller.

    """
    return _solver.system_get_routing_totals()

def system_get_runoff_totals():
    r"""
    Get system runoff totals.

    Returns
    -------
    runoffTot: SM_RunoffTotals *
        The system Runoff Stats struct (see :ref: SM_RunoffTotals).
        pre-allocated by the caller.

    """
    return _solver.system_get_runoff_totals()

def link_set_target_setting(index, setting):
    r"""
    Set a link setting (pump, orifice, or weir). Setting for an orifice and a 
    weir should be [0, 1]. A setting for a pump can range from [0, inf). However, 
    if a pump is set to 1, it will pump at its maximum curve setting.

    Parameters
    ----------
    index: int
        The link index.
    setting: double
        The new setting for the link.

    """
    return _solver.link_set_target_setting(index, setting)

def node_set_total_inflow(index, flowrate):
    r"""
    Set an inflow rate to a node. The inflow rate is held constant until the 
    caller changes it.

    Parameters
    ----------
    index: int
        The node index.
    flowrate: double
        The new node inflow rate.

    """
    return _solver.node_set_total_inflow(index, flowrate)

def outfall_set_stage(index, stage):
    r"""
    Set outfall stage.

    Parameters
    ----------
    index: int
        The outfall node index.
    stage: double
        The outfall node stage (head).

    """
    return _solver.outfall_set_stage(index, stage)

def raingage_set_precipitation(index, total_precip):
    r"""
    Set a total precipitation intensity to the gage.

    Parameters
    ----------
    index: int
        The gage index.
    total_precip: double
        The new total precipitation intensity.

    """
    return _solver.raingage_set_precipitation(index, total_precip)

cvar = _solver.cvar

