"""Classes to handle the GUI side of variables."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
from datetime import datetime

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class Metadata:
    """Data class to metadata."""

    def __init__(self, name='', client=None, design_by=None, latitude=0.0, longitude=0.0, x=0.0, y=0.0, z=0.0):
        """Initialize the MetaData class.

        Args:
            name (string): name of the CalcData
            client (personnel): Name of the client
            design_by (string): Name of the designer
            latitude (float): Latitude
            longitude (float): Longitude
            x (float): x coordinate
            y (float): y coordinate
            z (float): z coordinate
        """
        self.name = name
        self.notes = ''

        # Project metadata
        self.is_project = False
        self.client = client
        self.designed_by = design_by
        self.reviewed_by = None
        self.approved_by = None

        # project & folder metadata
        self.is_folder = False
        self.existing = False
        self.proposed = False

        self.district = ''
        self.address = ''
        self.county = ''
        self.city = ''
        self.USstate = ''
        self.zip = ''

        # Back to calc metadata
        self.created_on = datetime.now()
        self.last_modified_on = datetime.now()

        self.latitude = latitude
        self.longitude = longitude

        self.x = x
        self.y = y
        self.z = z

        self.photos_and_captions = []
