"""ActionRouter class to send view actions to controller."""

__copyright__ = "(C) Aquaveo 2022"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
from typing import Any, Callable, Dict, Optional, Tuple

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


Action = Tuple[str, str, Dict[str, Any]]


@dataclass
class ActionRouter:
    """Route actions for handling."""
    actions: list[Action] = field(default_factory=list)
    handler: Optional[Callable[[str, str, dict], None]] = None

    def send_action(self, class_name: str, method_name: str, params: Optional[Dict[str, Any]] = None) -> None:
        """
        Send an action to be handled.

        Args:
            class_name: The controller class.
            method_name: The view action.
            params: Additional action parameter values.
        """
        params = {} if params is None else params.copy()
        if self.handler is not None:
            return self.handler(class_name, method_name, params)
        else:
            return self.actions.append((class_name, method_name, params))


action_router: ActionRouter = ActionRouter()
