"""Classes to Define the view-model of a dialog."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.FhwaVariable.interface_adapters.view_model.window_base import WindowBase


class Dialog(WindowBase):
    """A class to define the view-model of a dialog."""
    def __init__(self, dlg_uuid: uuid.UUID):
        """Initialize the dialog class."""
        self.dlg_uuid = dlg_uuid

        self.splitter_h = []
        self.splitter_v = []

        self.plot_windows = 0
        self.plot_windows_data_list = []

        # Dialog data
        self.calc_type = None

        self.input_table_tabs = {}
        self.dual_input_name = 'Input (continued)'  # Name to be put on the group box containing dual input tables
        self.dual_input_table_tabs = {}
        self.stack_input_tables = True
        self.warnings_list = []
        self.results_table_tabs = {}
        self.plots_dict = {}
        self.show_plot = True
        self.external_plot = False

        self.docs = {}

        # Default help url will load when the dialog is created
        # Help url will load on next update (load helps from clicked links)
        self.default_help_url = ''
        self.help_url = ''
        self.show_wiki = True
        self.external_wiki = False

        self.undo_list = []
        self.redo_list = []

        # Settings
        self.system_complexity = 0
        self.dialog_columns = 1
        self.copy_headers = True
