"""Model view class for CalcData definitions in the model interactor."""
__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class CalcDataItem():
    """A class that defines the about information for a CalcData item in the CalcData dict."""

    def __init__(self, name, item_class, calc_uuid=None, icon=None, tool_tip=None, menu_group='', add_toolbar=True,
                 complexity=0):
        """Initializes the CalcDataItem.

        Args:
            name (string): name of the CalcData
            item_class (CalcData): class of the CalcData
            calc_uuid (uuid): uuid of the CalcData
            icon (string): path to the icon
            tool_tip (string): tool tip
            menu_group (string): Add this CalcData to the menu as a sub-menu under this name
            add_toolbar (bool): Add this CalcData to the toolbar
            complexity (int): The complexity level of this CalcData
        """
        self.uuid = calc_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        self.name = name
        self.item_class = item_class
        self.icon = icon
        self.tool_tip = tool_tip
        self.menu_group = menu_group
        self.add_toolbar = add_toolbar
        self.complexity = complexity
        self.assignments = []
