"""Classes to Define the model-view of the main interface."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
# from xms.FhwaVariable.core_data.calculator.tree_data import TreeData
# from xms.FhwaVariable.core_data.calculator.metadata import Metadata


class SupportWindow:
    """A class to define the model-view of the main interface."""
    def __init__(self, app_uuid: uuid.UUID = None, window_index: int = 0, app_title: str = '', icon: str = ''):
        """Initialize the main interface class."""
        self.uuid = app_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        self.support_window_index = window_index

        self.window_title = f'{app_title} - Support Window {window_index + 1}'
        self.icon = icon
        self.status_message = ''

        # Screen, screen size, and screen position
        # screen = None

        self.maximized = False
        self.minimized = False

        self.x = 100
        self.y = 100
        self.width = 800
        self.height = 600

        # TODO: Consider adding options to dock windows from main window
        self.windows = {}

        self.show_dialog_plots = False
        self.plot_dock_area = 'left'
        self.plots_dict = {}

        self.show_wiki = True
        self.wiki_dock_area = 'right'
        self.use_only_this_wiki = False
        self.use_only_this_wiki_enabled = False
        self.wiki_start_url = "https://www.xmswiki.com/wiki/Main_Page"
        self.wiki_url = ""

        # self.title_bg_color = (0, 0, 0)
        # self.title_text_color = (255, 255, 255)
        # self.bg_color = (0, 0, 0)
        # self.text_color = (255, 255, 255)
        # self.selected_bg_color = None
        # self.selected_text_color = None
        # self.hover_bg_color = None
        # self.hover_text_color = None
        # self.item_bg_color = (0, 0, 0)
        # self.item_text_color = (255, 255, 255)
        # self.doc_bg_color = (0, 0, 0)
