"""GradationManagerData Class."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.calculator.variable_group import VariableGroup
from xms.FhwaVariable.core_data.variables.variable import Variable

# 4. Local modules


class BridgeWaterProperties(VariableGroup):
    """Provides a class that will define a class that manages a list of gradation sets."""

    def __init__(self, app_data=None, model_name=None, project_uuid=None):
        """Initializes the Class.

        Args:
            app_data (AppData): The application data.
            model_name (str): The name of the model.
            project_uuid (str): The project UUID.
        """
        super().__init__(app_data=app_data, model_name=model_name, project_uuid=project_uuid)

        self.name = 'Water Properties'
        self.type = 'bridgeWaterProperties'

        # max_value = self.max_value
        # Input
        self.input = {}

        _, gamma_w = self.get_setting('Unit weight of water (γw)')
        self.input['Unit weight of water (γw)'] = Variable(
            'Unit weight of water (γw)',
            'float',
            gamma_w,
            precision=4,
            complexity=1,
            unit_type=["specific_weight"],
            native_unit="lb/ft^3",
            us_units=[["lb/ft^3"]],
            si_units=[["kN/m^3", "N/m^3"]])

        _, rho_w = self.get_setting('Water density', 1.94)
        self.input['Water density (ρw)'] = Variable(
            'Water density (ρw)',
            'float',
            rho_w, [],
            precision=2,
            complexity=1,
            unit_type=['specific_weight'],
            native_unit='slug/ft^3',
            us_units=[['slug/ft^3']],
            si_units=[['kN/m^3', 'N/m^3']])
