"""This module provides the GradationSettings class."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules
import sys

# 2. Third party modules

# 3. Aquaveo modules
from xms.FhwaVariable.core_data.calculator.setting_group import SettingGroup
from xms.FhwaVariable.core_data.variables.variable import Variable

# 4. Local modules


class BridgeScourSettings(SettingGroup):
    """Provides definitions for the gradation setings."""

    def __init__(self, name=None, version=None, agency=None, developed_by=None):
        """Initializes the gradation settings values."""
        super().__init__(name, version, agency, developed_by)

        self.input['Shear decay curve increment'] = Variable(
            'Shear decay curve increment', 'float', 0.5, precision=6,
            limits=(-sys.float_info.max, sys.float_info.max), unit_type=['length'], native_unit='ft',
            us_units=self.us_short_length, si_units=self.si_short_length,
            note='If your shear decay curve has lines, decrease this number. '
                 'If your shear decay calculation is slow, increase this number.')

        self.input['Include contraction shear'] = Variable(
            'Include contraction shear decay in local shear decay', 'bool', True)
