"""This module provides the CalculationNumbers class."""
__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.FhwaVariable.core_data.calculator.setting_group import SettingGroup
from xms.FhwaVariable.core_data.variables.variable import Variable


class CalculationNumbers(SettingGroup):
    """Provides definitions for the themes."""

    def __init__(self, name=None, version=None, agency=None, developed_by=None):
        """Initializes the calculation values."""
        super().__init__(name, version, agency, developed_by)

        self.name = 'CalculationNumbers'
        self.type = 'CalculationNumbers'

        self.input['Horizontal tolerance'] = Variable(
            'Definition of a slope equal to or less that will be determined to be an horizontal slope',
            'float', 0.000001, [], limits=(0.0, 10.0), precision=10, unit_type=['slope'],
            native_unit='ft/ft', us_units=[['ft/ft']], si_units=[['m/m']])
        self.input['Minimum number of points for direct step curve'] = Variable(
            'Minimum number of points for direct step curve', 'int', 6, [], complexity=2)
        self.input['Maximum number of points for direct step curve'] = Variable(
            'Maximum number of points for direct step curve', 'int', 300, [], complexity=2)
        self.input['Sequent error'] = Variable('Allowable error in sequent depth computations', 'float', 0.00001, [],
                                               complexity=2, precision=8)
        self.input['HW error'] = Variable('Allowable error in headwater computations', 'float', 0.001, [],
                                          complexity=2, precision=8)
        self.input['n error'] = Variable("Allowable error in gradation Manning's n computations", 'float', 0.0001,
                                         [], complexity=2, precision=8)
        self.input['Flow error'] = Variable('Allowable error in flow computations', 'float', 0.001, [],
                                            complexity=2, precision=8)
        percent_units = ['%', 'decimal']
        self.input['Flow % error'] = Variable('Allowable error in percent of flow in flow computations', 'float',
                                              0.01, [], complexity=2, precision=2, native_unit='decimal',
                                              us_units=[percent_units], si_units=[percent_units])
        self.input['Flow % error'].selected_us_unit = '%'

        self.input['Number of points computed for shapes'] = Variable('Number of points computed for shapes', 'int',
                                                                      37, limits=(8, 2147483647), complexity=1)
        self.input['Max number of iterations'] = Variable('Maximum number of iterations', 'int', 500,
                                                          limits=(0, 2147483647), complexity=2)
        self.input['Number of divisions for interpolation curve'] = Variable(
            'Number of divisions for interpolation curve', 'int', 10, limits=(2, 2147483647), complexity=2,
            note='number of times a domain is divided up to determine curve that is used with interpolation in '
                 'iterative solutions (for example, determining the channel depth for user-specified flow)')
        self.input['Brink depth end depth ratio'] = Variable(
            'Brink depth end depth ratio', 'float', 0.8, limits=(0.7, 0.8), complexity=2, precision=2,
            note='Brink depth end depth ratio used for shapes that do not have a defined brink EDR or equation.')
