"""Used to hold AdcircData class, now just a constant and helper methods."""

# 1. Standard Python modules
import datetime
import os

# 2. Third party modules
import numpy as np
from PySide2.QtCore import QDateTime

# 3. Aquaveo modules
from xms.api.dmi import XmsEnvironment as XmEnv
from xms.guipy.time_format import ISO_DATETIME_FORMAT, qdatetime_to_datetime

# 4. Local modules
from xms.adcirc.feedback.xmlog import XmLog

UNINITIALIZED_COMP_ID = -1

# This file used to contain a base class, which has been removed.
# The file remains to keep that constant above to keep everything working (without copying it to every file).


def file_exists(filename):
    """Check if a file exists and log a warning if it does not.

    Args:
        filename (:obj:`str`): Path to the file to check

    Returns:
        (:obj:`bool`): True if the file exists, False otherwise
    """
    if not os.path.isfile(filename):
        if XmEnv.xms_environ_running_tests() == 'TRUE':  # Don't report full path if testing
            XmLog().instance.warning(f'Unable to find referenced file: {os.path.basename(filename)}')
        else:
            XmLog().instance.warning(f'Unable to find referenced file: {filename}')
        return False
    return True


def check_for_object_strings_dumb(dset, variables):
    """Need this stupid check because xarray.where() switches the dtype of empty string variables to object.

    object dtype fails when serializing to NetCDF.

    Args:
        dset (:obj:`xarray.Dataset`): The Dataset to check for bad string variables
        variables (:obj:`Iterable`): The names of the string variables that are potentially bad
    """
    for variable in variables:
        if variable in dset and dset[variable].dtype == object:
            dset[variable] = dset[variable].astype(np.unicode_)


def fix_datetime_format(attrs, attr_name):
    """Ensure string datetimes are in YYYY-MM-DD HH:MM:SS format.

    Args:
        attrs (:obj:`dict`): The attrs dict containing the datetime
        attr_name (:obj:`str`): Key in attrs of the datetime
    """
    try:  # Try to parse using current locale
        qreftime = QDateTime.fromString(attrs[attr_name])
        reftime = qdatetime_to_datetime(qreftime)
    except Exception:
        try:  # Try to parse using ISO format
            reftime = datetime.datetime.strptime(attrs[attr_name], ISO_DATETIME_FORMAT)
        except Exception:  # Set default to 01/01/1950 epoch
            reftime = datetime.datetime(1950, 1, 1)
    attrs[attr_name] = reftime.strftime(ISO_DATETIME_FORMAT)  # Reformat to ISO datetime representation
