"""Constants used by the check levee tools and dialogs."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

TOOL_TYPE_CREST_ELEVATION = 0
TOOL_TYPE_GROUND_ELEVATION = 1
TOOL_NAMES = {  # Tool definition name
    TOOL_TYPE_CREST_ELEVATION: 'Check/Fix Levee Crest Elevations',
    TOOL_TYPE_GROUND_ELEVATION: 'Check/Fix Levee Ground Elevations',
}
TOOL_DESCRIPTIONS = {  # Tool definition description
    TOOL_TYPE_CREST_ELEVATION: 'Tool to check and adjust levee pair crest elevations against a check geometry '
                               'coverage.',
    TOOL_TYPE_GROUND_ELEVATION: 'Tool to check and adjust levee pair ground elevations against the defined levee '
                                'crest elevation curve.',
}
TOOL_SERIES_NAMES = {  # Title of the results curves plot
    TOOL_TYPE_CREST_ELEVATION: 'Check vs. Crest Elevation',
    TOOL_TYPE_GROUND_ELEVATION: 'Adjusted Ground Elevations',
}

# Text for log message that varies based on what tool implementation checks
TOOL_REPORT_HEADERS = {  # Header for printing report to log window
    TOOL_TYPE_CREST_ELEVATION: 'Node 1 ID   Node 2 ID   Crest Elevation (original)   Crest Elevation (adjusted)',
    TOOL_TYPE_GROUND_ELEVATION: 'Node 1 ID   Node 2 ID   Elevation 1 (adjusted)   Elevation 1 (original)   '
                                'Elevation 2 (adjusted)   Elevation 2 (original)',
}
TOOL_ELEVATION_SOURCE = {  # Type of elevation source tool uses for check (the baseline)
    TOOL_TYPE_CREST_ELEVATION: 'check',  # Adjusts levee crest elevation curves relative to a check geometry
    TOOL_TYPE_GROUND_ELEVATION: 'crest',  # Adjusts mesh node elevations relative to levee crest elevation curves
}

# Columns in the results table
RESULTS_STATUS_COL_IDX = 2  # Index of the status filter column
RESULTS_START_HIDE_COL_IDX = 3  # Everything after the status filter column is hidden in table
RESULTS_START_CURVE_COL_IDX = 5  # Index of the first curve column in the DataFrame
RESULTS_CHECK_ELEVATION_COL_NAME = 'Check Elevation'

# Format specifiers for log messages sent to the results dialog via the results DataFrame
LOG_LEVEL_SUCCESS = '$XMS_SUCCESS$'  # Insert before message to make text green
LOG_LEVEL_WARNING = '$XMS_WARNING$'  # Insert before message to make text orange
LOG_LEVEL_ERROR = '$XMS_ERROR$'  # Insert before message to make text red
LOG_MESSAGE_BOLD = '$XMS_BOLD$'  # Insert before message to make bold. Should come after level specifier if using both.
LOG_MESSAGE_DELIM = '$XMS_NEWLINE$'  # Insert between messages to separate

# Levee check status stuff
CHECK_STATUS_ADJUSTED = 0
CHECK_STATUS_ADJUSTED_ISSUE = 1
CHECK_STATUS_UNADJUSTED = 2
CHECK_STATUS_UNADJUSTED_ISSUE = 3
CHECK_STATUS_TEXT = {  # 'Status' column text in the results dialog
    CHECK_STATUS_ADJUSTED: 'Adjusted without issue',
    CHECK_STATUS_ADJUSTED_ISSUE: 'Adjusted with issue',
    CHECK_STATUS_UNADJUSTED: 'Unadjusted without issue',
    CHECK_STATUS_UNADJUSTED_ISSUE: 'Unadjusted with issue',
}

LEVEE_ISSUE_INVALID_DEFINITION = 0  # Bad snap
LEVEE_ISSUE_NODE_IN_MULTIPLE_LEVEES = 1  # Node appears in multiple levee definitions
LEVEE_ISSUE_NO_INTERSECT = 2  # No intersection with check geometry
LEVEE_ISSUE_PARTIAL_INTERSECT = 3  # Partial intersection with check geometry
LEVEE_ISSUE_MULTI_INTERSECT = 4  # Invalid multi-intersection
LEVEE_ISSUE_BUFFER_INTERSECT = 5  # Failed a projection units sanity check
LEVEE_ISSUE_PARTIAL_USED_CHECK_LINE = 6  # Intersecting check line extends beyond levee
LEVEE_ISSUE_UNITS_MISMATCH = 7  # Failed a projection units sanity check
LEVEE_ISSUE_TEXT = {
    LEVEE_ISSUE_INVALID_DEFINITION: 'Invalid levee definition',
    LEVEE_ISSUE_NODE_IN_MULTIPLE_LEVEES: 'Node(s) in multiple levees',
    LEVEE_ISSUE_NO_INTERSECT: 'No check line',
    LEVEE_ISSUE_PARTIAL_INTERSECT: 'Gaps in check line or incomplete check line',
    LEVEE_ISSUE_MULTI_INTERSECT: 'Multiple check line intersection(s)',
    LEVEE_ISSUE_BUFFER_INTERSECT: 'Intersection(s) required buffering',
    LEVEE_ISSUE_PARTIAL_USED_CHECK_LINE: 'Partially unused check line',
    LEVEE_ISSUE_UNITS_MISMATCH: 'Potential units mismatch',
}
