"""This module for tracks the progress of an AdH run."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

if __name__ == "__main__":  # pragma: no cover
    try:
        from xms.adh.dmi.adh_progress import AdHTracker
        tracker = AdHTracker()
        tracker.start_tracking()
    except Exception as ex:
        import os
        import traceback
        with open(f'adh_progress_error_{os.getpid()}.log', 'a') as file:
            traceback.print_exception(type(ex), ex, ex.__traceback__, file=file)
        raise ex  # Let XMS know we failed until we implement better feedback mechanism
