"""VesselData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel, Section
from xms.gmi.data_bases.coverage_base_data import CoverageBaseData

# 4. Local modules
from xms.adh.data.model import get_model


class VesselData(CoverageBaseData):
    """Manages data for the vessel coverage."""
    @property
    def vessel_data(self) -> Section:
        """Generic model section with vessel coverage parameters."""
        section = get_model().model_parameters
        vals = self.vessel_values
        if vals:
            section.restore_values(vals)
        return section

    @property
    def vessel_values(self) -> str:
        """Values for vessel coverage parameters."""
        if 'VESSEL_VALUES' in self.info.attrs:
            return self.info.attrs['VESSEL_VALUES']
        else:  # Let GenericModel get the default parameter values
            return GenericModel().model_parameters.extract_values()

    @vessel_values.setter
    def vessel_values(self, value: str):
        """Values for vessel coverage parameters."""
        self.info.attrs['VESSEL_VALUES'] = value
