"""Aeolis coverage component."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'
__all__ = ['AeolisCoverageComponent']

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.component_bases.coverage_component_base import CoverageComponentBase
from xms.gmi.data.generic_model import Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.aeolis.data.model import get_model


class AeolisCoverageComponent(CoverageComponentBase):
    """A Dynamic Model Interface (DMI) component base for the HYDRO_AS-2D model."""
    def _get_section(self, target: TargetType) -> Section:
        return get_model().section_from_target_type(target)
