"""Python wrapping for xms.api._xmsapi.XmsAgent."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi import XmsAgent as CXmsAgent
from xms.api.dmi.Session import Session as PySession


class XmsAgent:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.XmsAgent.

    Note that this class should never be created directly. Retrieve the XmsAgent of an xms.api.dmi.Query to access
    the process xms.api.dmi.Session or to adjust timing options.
    """
    def __init__(self, instance=None):
        """Construct the wrapper.

        Args:
            instance (xms.api._xmsapi.CXmsAgent): The C++ object to wrap
        """
        if instance is None:
            self._instance = CXmsAgent()
        else:
            self._instance = instance

    @property
    def session(self):
        """Returns the xms.api.dmi.Session of the agent."""
        return PySession(instance=self._instance.GetSession())

    def set_timeout(self, timeout):
        """Set the interprocess communication timeout interval.

        Default value is 10000 (milliseconds).

        Args:
            timeout (int): The maximum number of milliseconds between messages. If exceeded, communication
                with XMS is terminated.
        """
        return self._instance.SetTimeout(timeout)

    def set_retries(self, retries):
        """Set the number of retry attempts for dropped interprocess communication messages.

        Default value is 3.

        Args:
            retries (int): The maximum number of retries allowed for a message. If message is not successfully
                received/sent within the threshold, communication with XMS is terminated.
        """
        return self._instance.SetRetries(retries)

    def set_keep_aliveness(self, keep_alive):
        """Set the interval for sending keep alive messages.

        Default value is 1.0.

        Args:
            keep_alive (float): Multiplier of the timeout interval at which to send keep alive messages.
                Should be a whole number or a quarter increment (e.g. 0.25, 1.0).
        """
        return self._instance.SetKeepAliveness(keep_alive)
