"""Initialize the package."""
from pathlib import Path

from xms.data_objects.parameters import *


def _init_windows_dll_paths():
    """Make sure the paths to all our dll dependencies will be searched when loading the .pyd.

    Since Python>=3.8, the current working directory and PATH are not searched when loading dlls for the sake of
    security (https://docs.python.org/3/whatsnew/3.8.html#ctypes), but this broke us. XMS wipes the PATH environment
    variable and adds its own trusted locations in the installation. Manually add these back into the list of
    locations to search for .dll dependencies.
    """
    import os
    dll_dirs = os.environ.get('PATH', '').strip(';').split(';')
    for dll_dir in dll_dirs:
        # Convert to absolute to avoid throwing exceptions on special cases like "." and ".."
        dll_path = Path(dll_dir).absolute()
        if dll_dir and dll_path.exists():
            os.add_dll_directory(dll_path)


_init_windows_dll_paths()
