# 1. Standard python modules
import argparse

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api.packaging.find_packages import find_xms_model_definitions

__copyright__ = "(C) Copyright Aquaveo 2020"
__license__ = "All rights reserved"

FIND_PACKAGES_ENTRY_POINT = 'find_packages'


def main():
    """The main routine."""
    arguments = argparse.ArgumentParser(description='xmsapi entry points')
    arguments.add_argument(dest='command', type=str, help='script to run')
    arguments.add_argument(dest='vars', nargs='*', help='other arguments')
    parsed_args = arguments.parse_args()
    if parsed_args.command == FIND_PACKAGES_ENTRY_POINT:
        find_xms_model_definitions()


if __name__ == "__main__":
    main()
