"""Python wrapping for xms.api._xmsapi.dmi.ModelCheckError."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import ModelCheckError as CModelCheckError


class ModelCheckError:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.ModelCheckError objects."""
    def __init__(self, problem=None, description=None, fix=None, instance=None):
        """Construct the wrapper.

        Args:
            problem (str): Short explanation of the problem
            description (str): In-depth description of the problem
            fix (str): Suggested fix
            instance (CModelCheckError): The C++ object to wrap
        """
        if instance is None:
            self._instance = CModelCheckError()
        else:
            self._instance = instance

        if problem is not None:
            self._instance.SetProblemText(problem)
        if description is not None:
            self._instance.SetDescriptionText(description)
        if fix is not None:
            self._instance.SetFixText(fix)

    @property
    def problem_text(self):
        """Returns the problem description text of the model check error."""
        return self._instance.GetProblemText()

    @problem_text.setter
    def problem_text(self, text):
        """Sets the problem description text of the model check error.

        Args:
            text (str): Explanation of the problem
        """
        self._instance.SetProblemText(text)

    @property
    def description_text(self):
        """Returns the in-depth description of the problem."""
        return self._instance.GetDescriptionText()

    @description_text.setter
    def description_text(self, text):
        """Sets the in-depth description of the problem.

        Args:
            text (str): Description of the problem
        """
        self._instance.SetDescriptionText(text)

    @property
    def fix_text(self):
        """Returns the text suggesting the user instructions for fixing the model check error."""
        return self._instance.GetFixText()

    @fix_text.setter
    def fix_text(self, text):
        """Sets the text suggesting the user instructions for fixing the model check error.

        Args:
            text (str): Suggested fix
        """
        self._instance.SetFixText(text)
