"""Python wrapping for xms.api._xmsapi.dmi.RequestBase."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api.dmi import Context as PyContext


class RequestBase:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.RequestBase objects."""
    def __init__(self, instance):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.RequestBase): The C++ object to wrap
        """
        self._instance = instance

    @property
    def process_id(self):
        """Returns the XMS-internal PID (not the OS PID) of the Python process owning the DataRequest."""
        return self._instance.GetProcessID()

    @process_id.setter
    def process_id(self, pid):
        """Sets the XMS-internal PID (not the OS PID) of the Python process owning the DataRequest.

        Args:
            pid (int): The DataRequest processes's XMS process id (not its OS PID).
        """
        self._instance.SetProcessID(pid)

    @property
    def context(self):
        """Returns the xms.api.dmi.Context associated with the DataRequest."""
        return PyContext(instance=self._instance.GetContext())

    @context.setter
    def context(self, ctxt):
        """Set the Context associated with the DataRequest.

        Args:
            ctxt (xms.api.dmi.Context): The DataRequest Context
        """
        self._instance.SetContext(ctxt._instance)

    @property
    def args(self):
        """Returns a list of the DataRequest arguments (element types defined by derived classes)."""
        return self._instance.GetArgs()

    @args.setter
    def args(self, request_args):
        """Sets the list of the DataRequest arguments.

        Args:
            request_args (list): Types of list elements are defined by derived classes
        """
        self._instance.SetArgs(request_args)
