"""Python wrapping for xms.api._xmsapi.dmi.SetDataResult."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import SetDataResult as CSetDataResult
from xms.api.dmi import Context as PyContext
from xms.api.dmi.ResultBase import ResultBase


class SetDataResult(ResultBase):
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.SetDataResult objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.SetDataResult): The C++ object to wrap
        """
        if instance is None:
            instance = CSetDataResult()
        super().__init__(instance)

    @property
    def context(self):
        """Returns the xms.api.dmi.Context associated with the SetDataResult."""
        return PyContext(instance=self._instance.GetContext())

    @context.setter
    def context(self, ctxt):
        """Set the Context associated with the SetDataResult.

        Args:
            ctxt (xms.api.dmi.Context): The SetDataResult Context
        """
        self._instance.SetContext(ctxt._instance)
