"""Entry points for the xmsbridge package."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import argparse
import sys

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.bridge.sms_bridge_scour_exporter import export_for_bridge_scour_coverage

XMSBRIDGE_COMMAND_BRIDGE_SCOUR_EXPORT = 'bridge_scour_export'


def main(arg_str=None):
    """The main routine.

    Args:
        arg_str (list): list of arguments for testing

    Returns:
        (int): return code
    """
    arguments = argparse.ArgumentParser(description='xmsbridge entry points')
    arguments.add_argument(dest='command', type=str, help='script to run')
    arguments.add_argument(dest='vars', nargs='*', help='other arguments')
    parsed_args = arguments.parse_args(arg_str)
    if parsed_args.command == XMSBRIDGE_COMMAND_BRIDGE_SCOUR_EXPORT:
        return export_for_bridge_scour_coverage(arg_str)  # Export bridge deck geometry for SMS Bridge Scour coverage.


if __name__ == "__main__":  # pragma: no cover
    sys.exit(main())
