"""Class to store data of a 3D Bridge definition."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import pandas

# 3. Aquaveo modules

# 4. Local modules


class Bridge:
    """Bridge definition."""
    def __init__(self):
        """Initializes the class."""
        self.arc_id_upstream = 0  # The upstream arc ID
        self.arc_id_downstream = 0  # The downstream arc ID
        default_data = {'Distance': [0.0], 'Elevation': [0.0]}
        self.df_top = pandas.DataFrame(default_data)  # The top cross section pandas dataframe
        self.df_upstream = pandas.DataFrame(default_data)  # The upstream cross section pandas dataframe
        self.df_downstream = pandas.DataFrame(default_data)  # The downstream cross section pandas dataframe
        self.manning_n = 0.03  # manning value for bridge ceiling
        self.specify_downstream_profile = False  # flag to specify downstream profile is different that upstream
