"""A table widget for advanced card block definitions."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtWidgets import QAbstractItemView

# 3. Aquaveo modules

# 4. Local modules
from xms.cmsflow.gui.cmsflow_table_widget import CmsflowTableWidget


class AdvancedBlockTableWidget(CmsflowTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (pandas.DataFrame): The model data.
        """
        super().__init__(parent, data_frame, 0, {'block_name': ' ', 'block_start': ' ', 'block_end': ' '})
        self.model.show_nan_as_blank = True
        self.table_view.setEditTriggers(QAbstractItemView.AllEditTriggers)

    def setup_ui(self):
        """Sets up the table."""
        super()._setup_ui({}, False, False)
