"""GUI utilities."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.tree import tree_util

# 4. Local modules


def find_domain_uuid(pe_tree, sim_uuid):
    """This method finds the UUID of the domain associated with the given simulation UUID.

    Args:
        pe_tree (xms.api.tree.Tree): The XMS PE tree object.
        sim_uuid (str): The UUID of the simulation.

    Returns:
        domain_uuid (str): The UUID of the domain associated with the simulation. If no domain is found, an empty string
            is returned.
    """
    domain_uuid = ''
    sim_item = tree_util.find_tree_node_by_uuid(pe_tree, sim_uuid)
    if sim_item:
        quad_item = tree_util.descendants_of_type(
            sim_item, xms_types=['TI_UGRID_PTR', 'TI_CGRID2D_PTR'], recurse=False, allow_pointers=True, only_first=True
        )
        if quad_item:
            domain_uuid = quad_item.uuid
    return domain_uuid
