"""This is a helper class for converting between units and setting the new value in the GUI."""

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.validators.qx_locale import QxLocale

# 4. Local modules


class UnitConverter:
    """A class for converting values between units."""
    @staticmethod
    def make_change_units(value_widget, unit_conversion_table, key, old_units_dict):
        """This creates a function for converting between units and setting the new value.

        Args:
            value_widget (QWidget): The widget to set the new value on.
            unit_conversion_table (list): A ordered list of conversion factors.
            key (str): The text shown for the base unit.
            old_units_dict (dict): A dictionary going from unit text to index in the unit_conversion_table.

        Returns:
            A function for converting number text to new text in a different unit.
        """
        def change_units(index):
            # Should be valid since the field should have a validator that uses QxLocale.
            old_value, _valid = QxLocale.toDouble(value_widget.text())
            # convert old value to base units
            old_value = old_value * unit_conversion_table[old_units_dict[key]]
            # convert to new units
            new_value = old_value / unit_conversion_table[index]
            new_double = str(new_value).replace('.', QxLocale.decimalPoint())
            value_widget.setText(new_double)
            old_units_dict[key] = index

        return change_units
